package com.chenyang.nse.bussiness.service.core.config.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.config.TcoreBaseConfigDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.config.TcoreBaseConfig;
import com.chenyang.nse.bussiness.service.core.config.BaseConfigService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import java.util.HashMap;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(
   rollbackFor = {Exception.class}
)
public class BaseConfigServiceImpl implements BaseConfigService {
   @Autowired
   private TcoreBaseConfigDao tcoreBaseConfigDao;
   @Autowired
   private RedisService redisService;
   public static final String BASE_CONFIG = TcoreBaseConfig.class.getSimpleName();

   public void removeConfigById(String id) {
      this.tcoreBaseConfigDao.removeById(id);
   }

   public void addConfig(TcoreBaseConfig config) {
      this.tcoreBaseConfigDao.save(config);
   }

   public TcoreBaseConfig getConfigById(String id) {
      return (TcoreBaseConfig)this.tcoreBaseConfigDao.get(id);
   }

   public List<TcoreBaseConfig> getConfigList(String groupName, String categoryName) {
      return this.tcoreBaseConfigDao.queryAll();
   }

   public void updateConfig(TcoreBaseConfig config) {
      this.tcoreBaseConfigDao.saveOrUpdate(config);
   }

   public List<String> getCategoryNameList() {
      return this.tcoreBaseConfigDao.getCategoryNameList();
   }

   public List<String> getGroupNameList(String categoryId) {
      return this.tcoreBaseConfigDao.getGroupNameList(categoryId);
   }

   public List<TcoreBaseConfig> getConfigList(String isEffectiveImmediately) {
      return null;
   }

   public void initConfig() {
      List<TcoreBaseConfig> tcoreBaseConfigList = this.tcoreBaseConfigDao.queryAll(new Criterion[]{Restrictions.eq("isEffectiveImmediately", 1)});
      HashMap<String, String> configMap = new HashMap(1000);

      for(TcoreBaseConfig tcoreBaseConfig : tcoreBaseConfigList) {
         configMap.put(tcoreBaseConfig.getId(), tcoreBaseConfig.getConfig_value());
      }

      this.redisService.add(BASE_CONFIG, configMap);
   }

   public List<TcoreBaseConfig> getConfigList(PageInfo pageInfo, String groupName, String categoryName) {
      String empty = "null";
      return !"".equals(groupName) && groupName != null && !empty.equals(groupName) && !"全部".equals(groupName) ? this.tcoreBaseConfigDao.queryByPageInfo(pageInfo, Order.desc("groupName"), new Criterion[]{Restrictions.eq("categoryName", categoryName), Restrictions.eq("groupName", groupName)}) : this.tcoreBaseConfigDao.queryByPageInfo(pageInfo, Order.desc("groupName"), new Criterion[]{Restrictions.eq("categoryName", categoryName)});
   }

   public String getConfigCnt(String categoryName) {
      return this.tcoreBaseConfigDao.getCategoryNameCnt(categoryName);
   }
}
