package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.core.ComplianceDirectoryDao;
import com.chenyang.nse.bussiness.dao.core.DataScopeDao;
import com.chenyang.nse.bussiness.dao.core.ProEditionScopeDao;
import com.chenyang.nse.bussiness.dao.core.SensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataAreaDao;
import com.chenyang.nse.bussiness.dao.table.core.duty.DutyTableInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.DutyTableInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.scopeproject.TProEditionScope;
import com.chenyang.nse.bussiness.entity.vo.api.DiscoverApiDirectoryVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.service.core.ApiDirectoryService;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.core.SensitiveLevelService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApiDirectoryServiceImpl implements ApiDirectoryService {
   @Autowired
   private TdataProjectService tdataProjectService;
   @Autowired
   private TdataDiscoveryService tdataDiscoveryService;
   @Autowired
   private DataScopeService dataScopeService;
   @Autowired
   private DataScopeDao dataScopeDao;
   @Autowired
   private TCoreDataAreaDao tCoreDataAreaDao;
   @Autowired
   private ProEditionScopeDao proEditionScopeDao;
   @Autowired
   private TCoreMaskingRuleinfoDao TCoreMaskingRuleinfoDao;
   @Autowired
   private SensitiveLevelService sensitiveLevelService;
   @Autowired
   private SensitiveLevelDao sensitiveLevelDao;
   @Autowired
   private ComplianceDirectoryDao complianceDirectoryDao;
   @Autowired
   private DutyTableInfoDao dutyTableInfoDao;

   public List<DiscoverApiDirectoryVO> getDiscoverApiDirectory(String projectid, String editionid) {
      List<DiscoverApiDirectoryVO> trees = new ArrayList();
      List<TCoreDataProject> list = this.tdataProjectService.selectDataProject();

      List<TCoreDataProject> listNew = (List)list.stream().filter((e) -> e.getId().equals(projectid) && e.getEdition_id().equals(editionid)).collect(Collectors.toList());
      for(TCoreDataProject tCoreDataProject : listNew) {
         DiscoverApiDirectoryVO discoverApiDirectoryVO = new DiscoverApiDirectoryVO();
         discoverApiDirectoryVO.setId(tCoreDataProject.getId());
         discoverApiDirectoryVO.setText(tCoreDataProject.getProject());
         List<TcoreDiscoveryTask> taskList = this.tdataDiscoveryService.queryDiscoverytasklistByProjectId(tCoreDataProject.getId());
         List<DiscoverApiDirectoryVO> childrenList = new ArrayList();

         for(TcoreDiscoveryTask tcoreDiscoveryTask : taskList) {
            DiscoverApiDirectoryVO discoverApiDirectoryChildren = new DiscoverApiDirectoryVO();
            discoverApiDirectoryChildren.setId(tcoreDiscoveryTask.getId());
            discoverApiDirectoryChildren.setProjectId(projectid);
            discoverApiDirectoryChildren.setText(tcoreDiscoveryTask.getTname());
            discoverApiDirectoryChildren.setFa_tid(tCoreDataProject.getId());
            if ("2".equals(tcoreDiscoveryTask.getDiscoverytype())) {
               if (StringUtils.isNotBlank(tcoreDiscoveryTask.getIsdmpflag())) {
                  discoverApiDirectoryChildren.setType("21");
               } else {
                  discoverApiDirectoryChildren.setType("22");
               }
            } else {
               discoverApiDirectoryChildren.setType("2");
            }

            childrenList.add(discoverApiDirectoryChildren);
         }

         if (childrenList.size() > 0) {
            discoverApiDirectoryVO.setState("closed");
         }

         discoverApiDirectoryVO.setChildren(childrenList);
         trees.add(discoverApiDirectoryVO);
      }

      return trees;
   }

   private List<DiscoverApiDirectoryVO> buildTree(List<DiscoverApiDirectoryVO> list, String parentId) {
      List<DiscoverApiDirectoryVO> trees = new ArrayList();

      for(DiscoverApiDirectoryVO entity : list) {
         String menuId = entity.getId();
         String pid = entity.getFa_tid();
         if (parentId.equals(pid)) {
            List<DiscoverApiDirectoryVO> menuLists = this.buildTree(list, menuId);
            entity.setChildren(menuLists);
            trees.add(entity);
         }
      }

      return trees;
   }

   public List<DiscoverApiDirectoryVO> getSortApiDirectory(String projectid, String editionid) {
      List<DiscoverApiDirectoryVO> trees = new ArrayList();
      List<TCoreDataProject> list = this.tdataProjectService.selectDataProject();

      List<TCoreDataProject> listNew = (List)list.stream().filter((e) -> e.getId().equals(projectid) && e.getEdition_id().equals(editionid)).collect(Collectors.toList());
      for(TCoreDataProject tCoreDataProject : listNew) {
         DiscoverApiDirectoryVO discoverApiDirectoryVO = new DiscoverApiDirectoryVO();
         discoverApiDirectoryVO.setId(tCoreDataProject.getId());
         discoverApiDirectoryVO.setText(tCoreDataProject.getProject());
         List<TProEditionScope> tProEditionScopeList = this.dataScopeService.geteditionlistByEditionId(editionid);
         List<DiscoverApiDirectoryVO> projectChildrenList = new ArrayList();

         for(TProEditionScope tProEditionScope : tProEditionScopeList) {
            DiscoverApiDirectoryVO versionApiDirectoryVO = new DiscoverApiDirectoryVO();
            versionApiDirectoryVO.setId(tProEditionScope.getId());
            versionApiDirectoryVO.setText(tProEditionScope.getEdition_name());
            versionApiDirectoryVO.setFa_tid(tCoreDataProject.getId());
            List<DiscoverApiDirectoryVO> sortlist = this.dataScopeDao.getDataScopeDirectory(tProEditionScope.getId());
            List<DiscoverApiDirectoryVO> levellist = this.sensitiveLevelDao.getLevelDirectory(editionid);
            List<DiscoverApiDirectoryVO> compliancelist = this.complianceDirectoryDao.getComplianceDirectory(tCoreDataProject.getEdition_id());
            versionApiDirectoryVO.setChildren(this.getFLFJAPIList(sortlist, levellist, compliancelist, editionid, projectid));
            projectChildrenList.add(versionApiDirectoryVO);
         }

         if (projectChildrenList.size() > 0) {
            discoverApiDirectoryVO.setState("closed");
         }

         discoverApiDirectoryVO.setChildren(projectChildrenList);
         trees.add(discoverApiDirectoryVO);
      }

      return trees;
   }

   private List<DiscoverApiDirectoryVO> getFLFJAPIList(List<DiscoverApiDirectoryVO> sortlist, List<DiscoverApiDirectoryVO> levellist, List<DiscoverApiDirectoryVO> compliancelist, String editionid, String projectid) {
      List<DiscoverApiDirectoryVO> resultList = new ArrayList();
      DiscoverApiDirectoryVO flVO = new DiscoverApiDirectoryVO();

      for(DiscoverApiDirectoryVO vo1 : sortlist) {
         vo1.setProjectId(projectid);
      }

      flVO.setFa_tid(editionid);
      flVO.setText("分类API");
      flVO.setChildren(this.buildTree(sortlist, "全部"));
      DiscoverApiDirectoryVO fjVO = new DiscoverApiDirectoryVO();

      for(DiscoverApiDirectoryVO vo2 : levellist) {
         vo2.setProjectId(projectid);
      }

      fjVO.setFa_tid(editionid);
      fjVO.setText("分级API");
      fjVO.setProjectId(projectid);
      fjVO.setChildren(this.buildTree(levellist, "全部"));
      DiscoverApiDirectoryVO hgVO = new DiscoverApiDirectoryVO();

      for(DiscoverApiDirectoryVO vo3 : compliancelist) {
         vo3.setProjectId(projectid);
      }

      hgVO.setFa_tid(editionid);
      hgVO.setText("合规API");
      hgVO.setProjectId(projectid);
      hgVO.setChildren(this.buildTree(compliancelist, "全部"));
      resultList.add(flVO);
      resultList.add(fjVO);
      resultList.add(hgVO);
      return resultList;
   }

   public List<DiscoverApiDirectoryVO> getLevelApiDirectory(String projectid, String editionid) {
      List<DiscoverApiDirectoryVO> trees = new ArrayList();
      List<TCoreDataProject> list = this.tdataProjectService.selectDataProject();

      List<TCoreDataProject> listNew = (List)list.stream().filter((e) -> e.getId().equals(projectid) && e.getEdition_id().equals(editionid)).collect(Collectors.toList());
      for(TCoreDataProject tCoreDataProject : listNew) {
         DiscoverApiDirectoryVO discoverApiDirectoryVO = new DiscoverApiDirectoryVO();
         discoverApiDirectoryVO.setId(tCoreDataProject.getId());
         discoverApiDirectoryVO.setText(tCoreDataProject.getProject());
         List<DiscoverApiDirectoryVO> projectChildrenList = new ArrayList();
         TProEditionScope tProEditionLevel = (TProEditionScope)this.proEditionScopeDao.queryUnique(new Criterion[]{Restrictions.eq("id", editionid)});
         DiscoverApiDirectoryVO versionApiDirectoryVO = new DiscoverApiDirectoryVO();
         versionApiDirectoryVO.setId(tProEditionLevel.getId());
         versionApiDirectoryVO.setText(tProEditionLevel.getEdition_name());
         versionApiDirectoryVO.setFa_tid(tCoreDataProject.getId());
         versionApiDirectoryVO.setType("4");
         versionApiDirectoryVO.setProjectId(tCoreDataProject.getId());
         List<DiscoverApiDirectoryVO> levellist = this.sensitiveLevelDao.getLevelDirectory(tProEditionLevel.getId());
         versionApiDirectoryVO.setChildren(this.buildTree(levellist, "全部"));
         projectChildrenList.add(versionApiDirectoryVO);
         if (projectChildrenList.size() > 0) {
            discoverApiDirectoryVO.setState("closed");
         }

         discoverApiDirectoryVO.setChildren(projectChildrenList);
         trees.add(discoverApiDirectoryVO);
      }

      return trees;
   }

   public List<DiscoverApiDirectoryVO> getComplianceApiDirectory(String projectid, String editionid) {
      List<DiscoverApiDirectoryVO> trees = new ArrayList();
      List<TCoreDataProject> list = this.tdataProjectService.selectDataProject();

      List<TCoreDataProject> listNew = (List)list.stream().filter((e) -> e.getId().equals(projectid) && e.getEdition_id().equals(editionid)).collect(Collectors.toList());
      for(TCoreDataProject tCoreDataProject : listNew) {
         DiscoverApiDirectoryVO discoverApiDirectoryVO = new DiscoverApiDirectoryVO();
         discoverApiDirectoryVO.setId(tCoreDataProject.getId());
         discoverApiDirectoryVO.setText(tCoreDataProject.getProject());
         discoverApiDirectoryVO.setProjectId(tCoreDataProject.getId());
         List<DiscoverApiDirectoryVO> compliancelist = this.complianceDirectoryDao.getComplianceDirectory(tCoreDataProject.getEdition_id());
         discoverApiDirectoryVO.setChildren(this.buildTree(compliancelist, "全部"));
         trees.add(discoverApiDirectoryVO);
      }

      return trees;
   }

   public List<DiscoverApiDirectoryVO> getDesensitizationApiDirectory(String projectid, String editionid) {
      List<DiscoverApiDirectoryVO> trees = new ArrayList();
      List<TCoreDataArea> tCoreDataAreaList = this.tCoreDataAreaDao.queryAll();
      if (tCoreDataAreaList != null) {
         for(TCoreDataArea tCoreDataArea : tCoreDataAreaList) {
            DiscoverApiDirectoryVO discoverApiDirectoryVO = new DiscoverApiDirectoryVO();
            discoverApiDirectoryVO.setId(tCoreDataArea.getId());
            discoverApiDirectoryVO.setText(tCoreDataArea.getDataarea());
            List<TCoreMaskingRuleinfo> tCoreMaskingRuleinfoList = this.TCoreMaskingRuleinfoDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", tCoreDataArea.getId())});
            List<DiscoverApiDirectoryVO> childrenList = new ArrayList();

            for(TCoreMaskingRuleinfo tCoreMaskingRuleinfo : tCoreMaskingRuleinfoList) {
               DiscoverApiDirectoryVO discoverApiDirectoryChildren = new DiscoverApiDirectoryVO();
               discoverApiDirectoryChildren.setId(tCoreMaskingRuleinfo.getId());
               discoverApiDirectoryChildren.setText(tCoreMaskingRuleinfo.getName());
               discoverApiDirectoryChildren.setFa_tid(tCoreDataArea.getId());
               discoverApiDirectoryChildren.setMappletname(tCoreMaskingRuleinfo.getMappletname());
               childrenList.add(discoverApiDirectoryChildren);
            }

            if (childrenList.size() > 0) {
               discoverApiDirectoryVO.setState("closed");
            }

            discoverApiDirectoryVO.setType("6");
            discoverApiDirectoryVO.setChildren(childrenList);
            trees.add(discoverApiDirectoryVO);
         }
      }

      return trees;
   }

   public List<DiscoverApiDirectoryVO> getAccountabilityApiDirectory(String projectid, String editionid) {
      List<DiscoverApiDirectoryVO> trees = new ArrayList();
      List<DatasystemProjectdatasourceVO> dataSourceList = this.tdataProjectService.queryDatasystemByProId(projectid);
      if (dataSourceList != null) {
         for(DatasystemProjectdatasourceVO vo : dataSourceList) {
            DiscoverApiDirectoryVO discoverApiDirectoryVO = new DiscoverApiDirectoryVO();
            discoverApiDirectoryVO.setId(vo.getTid());
            discoverApiDirectoryVO.setText(vo.getSysname());
            List<DutyTableInfo> schemalist = this.dutyTableInfoDao.querySchemaList(projectid, vo.getTid());
            List<DiscoverApiDirectoryVO> childrenList = new ArrayList();

            for(DutyTableInfo dutyTableInfo : schemalist) {
               DiscoverApiDirectoryVO discoverApiDirectoryChildren = new DiscoverApiDirectoryVO();
               discoverApiDirectoryChildren.setId(vo.getTid());
               discoverApiDirectoryChildren.setText(dutyTableInfo.getSchemaname());
               discoverApiDirectoryChildren.setType("7");
               discoverApiDirectoryChildren.setProjectId(projectid);
               List<DutyTableInfo> tablelist = this.dutyTableInfoDao.queryTableList(projectid, vo.getTid(), dutyTableInfo.getSchemaname());
               List<DiscoverApiDirectoryVO> sonList = new ArrayList();

               for(DutyTableInfo d : tablelist) {
                  DiscoverApiDirectoryVO discoverApiDirectoryChildrenSon = new DiscoverApiDirectoryVO();
                  discoverApiDirectoryChildrenSon.setId(d.getId());
                  discoverApiDirectoryChildrenSon.setProjectId(projectid);
                  discoverApiDirectoryChildrenSon.setEdition_id(vo.getTid());
                  discoverApiDirectoryChildrenSon.setText(d.getTablename());
                  discoverApiDirectoryChildrenSon.setType("8");
                  discoverApiDirectoryChildrenSon.setProjectId(projectid);
                  sonList.add(discoverApiDirectoryChildrenSon);
               }

               discoverApiDirectoryChildren.setChildren(sonList);
               childrenList.add(discoverApiDirectoryChildren);
            }

            if (childrenList.size() > 0) {
               discoverApiDirectoryVO.setState("closed");
            }

            discoverApiDirectoryVO.setType("6");
            discoverApiDirectoryVO.setProjectId(projectid);
            discoverApiDirectoryVO.setChildren(childrenList);
            trees.add(discoverApiDirectoryVO);
         }
      }

      return trees;
   }
}
