package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.batchmanage.BatchManageDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.batchmanage.BatchManage;
import com.chenyang.nse.bussiness.service.core.BatchManageService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BatchManageServiceImpl implements BatchManageService {
   @Autowired
   private BatchManageDao batchManageDao;

   public List<BatchManage> queryBatchManage(PageInfo pageInfo) {
      List<BatchManage> list = this.batchManageDao.queryByPageInfo(pageInfo, Order.desc("createtime"));
      return list;
   }

   public long querybatchManagenum(String batchmanagenum, String batchmanageid) {
      return this.batchManageDao.count(new Criterion[]{Restrictions.eq("batchnumber", Integer.parseInt(batchmanagenum)), Restrictions.ne("id", batchmanageid)});
   }

   public void updateorsaveBatchManage(BatchManage batchManage) {
      this.batchManageDao.saveOrUpdate(batchManage);
   }

   public BatchManage querybatchManageById(String batchmanageid) {
      return (BatchManage)this.batchManageDao.get(batchmanageid);
   }

   public void removeBatchManage(String batchmanageid) {
      this.batchManageDao.removeById(batchmanageid);
   }

   public List<BatchManage> queryBatchManageAll() {
      List<BatchManage> list = this.batchManageDao.queryAll(Order.desc("createtime"), new Criterion[0]);
      return list;
   }
}
