package com.chenyang.nse.bussiness.controller.core;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.vo.auditlog.AccessPojo;
import com.chenyang.nse.bussiness.entity.vo.auditlog.DbAccessPojo;
import com.chenyang.nse.bussiness.tools.audit.AuditLogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/auditlog"})
public class AuditLogController {
   @RequestMapping({"/query"})
   @ResponseBody
   public Response query(@RequestParam Map<String, Object> params, Integer pageno, Integer pagesize, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(pageno);
      pageInfo.setPagesize(pagesize);
      String schema = (String)params.get("schema");
      String tablename = (String)params.get("tablename");
      String sqltype = (String)params.get("sqltype");
      String action = (String)params.get("action");
      List<JSONObject> auditlist = AuditLogUtil.toArrayByFileReader();
      List<AccessPojo> accessPojoList = new ArrayList();
      auditlist.stream().forEach((audit) -> {
         AccessPojo accessPojo = (AccessPojo)JSONUtil.toBean(audit.getString("message"), AccessPojo.class);
         accessPojoList.add(accessPojo);
      });
      List<AccessPojo> searchList = accessPojoList;
      List<AccessPojo> retList = new ArrayList();
      if (accessPojoList.size() > 0) {
         if (StringUtils.isNotBlank(schema)) {
            searchList = (List)accessPojoList.stream().filter((log) -> log.getSchema().equalsIgnoreCase(schema)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(sqltype)) {
            searchList = (List)searchList.stream().filter((log) -> log.getSqltype().equalsIgnoreCase(sqltype)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(action)) {
            searchList = (List)searchList.stream().filter((log) -> log.getAction().equalsIgnoreCase(action)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(tablename)) {
            searchList = (List)searchList.stream().filter((log) -> log.getTables().contains(tablename)).collect(Collectors.toList());
         }

         pageInfo.setCount((long)searchList.size());
         retList = (List)searchList.stream().skip((long)((pageno - 1) * pagesize)).limit((long)pagesize).collect(Collectors.toList());
      }

      return RespHelper.updateResp(pageInfo, retList);
   }

   @RequestMapping({"/queryDbMatch"})
   @ResponseBody
   public Response queryDbMatch(@RequestParam Map<String, Object> params, Integer pageno, Integer pagesize, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(pageno);
      pageInfo.setPagesize(pagesize);
      String accesstool = (String)params.get("accesstool");
      String accessoruser = (String)params.get("accessoruser");
      String sqltype = (String)params.get("sqltype");
      String action = (String)params.get("action");
      String matchstatus = (String)params.get("matchstatus");
      String datasourceid = (String)params.get("datasourceid");
      List<JSONObject> auditlist = AuditLogUtil.toArrayByFileReaderOfDb("1");
      List<DbAccessPojo> dbAccessPojoList = new ArrayList();
      new ArrayList();
      auditlist.stream().forEach((audit) -> {
         DbAccessPojo dbAccessPojo = (DbAccessPojo)JSONUtil.toBean(audit.getString("message"), DbAccessPojo.class);
         dbAccessPojoList.add(dbAccessPojo);
      });
      List<DbAccessPojo> reversedDbAccessPojoList = (List)dbAccessPojoList.stream().sorted(Comparator.comparing(DbAccessPojo::getAccessDate).reversed()).collect(Collectors.toList());
      List<DbAccessPojo> searchList = reversedDbAccessPojoList;
      List<DbAccessPojo> retList = new ArrayList();
      if (reversedDbAccessPojoList.size() > 0) {
         if (StringUtils.isNotBlank(accessoruser)) {
            searchList = (List)reversedDbAccessPojoList.stream().filter((log) -> log.getAccessOsUser().equalsIgnoreCase(accessoruser)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(sqltype)) {
            searchList = (List)searchList.stream().filter((log) -> log.getAccessSqlType().equalsIgnoreCase(sqltype)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(action)) {
            searchList = (List)searchList.stream().filter((log) -> log.getImpactAction().equalsIgnoreCase(action)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(accesstool)) {
            searchList = (List)searchList.stream().filter((log) -> log.getAccessClient().contains(accesstool)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(matchstatus)) {
            searchList = (List)searchList.stream().filter((log) -> log.getStatus().equals(matchstatus)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(datasourceid)) {
            searchList = (List)searchList.stream().filter((log) -> log.getStrategyId().equals(datasourceid)).collect(Collectors.toList());
         }

         pageInfo.setCount((long)searchList.size());
         retList = (List)searchList.stream().skip((long)((pageno - 1) * pagesize)).limit((long)pagesize).collect(Collectors.toList());
      }

      return RespHelper.updateResp(pageInfo, retList);
   }

   @RequestMapping({"/queryDbAccess"})
   @ResponseBody
   public Response queryDbAccess(@RequestParam Map<String, Object> params, Integer pageno, Integer pagesize, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(pageno);
      pageInfo.setPagesize(pagesize);
      String accesstool = (String)params.get("accesstool");
      String accessoruser = (String)params.get("accessoruser");
      String sqltype = (String)params.get("sqltype");
      String action = (String)params.get("action");
      String exestatus = (String)params.get("exestatus");
      String datasourceid = (String)params.get("datasourceid");
      List<JSONObject> auditlist = AuditLogUtil.toArrayByFileReaderOfDb("0");
      List<DbAccessPojo> dbAccessPojoList = new ArrayList();
      new ArrayList();
      auditlist.stream().forEach((audit) -> {
         DbAccessPojo dbAccessPojo = (DbAccessPojo)JSONUtil.toBean(audit.getString("message"), DbAccessPojo.class);
         dbAccessPojoList.add(dbAccessPojo);
      });
      List<DbAccessPojo> reversedDbAccessPojoList = (List)dbAccessPojoList.stream().sorted(Comparator.comparing(DbAccessPojo::getAccessDate).reversed()).collect(Collectors.toList());
      List<DbAccessPojo> searchList = reversedDbAccessPojoList;
      List<DbAccessPojo> retList = new ArrayList();
      if (reversedDbAccessPojoList.size() > 0) {
         if (StringUtils.isNotBlank(accessoruser)) {
            searchList = (List)reversedDbAccessPojoList.stream().filter((log) -> log.getAccessOsUser().equalsIgnoreCase(accessoruser)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(sqltype)) {
            searchList = (List)searchList.stream().filter((log) -> log.getAccessSqlType().equalsIgnoreCase(sqltype)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(action)) {
            searchList = (List)searchList.stream().filter((log) -> log.getImpactAction().equalsIgnoreCase(action)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(accesstool)) {
            searchList = (List)searchList.stream().filter((log) -> log.getAccessClient().contains(accesstool)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(exestatus)) {
            searchList = (List)searchList.stream().filter((log) -> log.getStatus().equals(exestatus)).collect(Collectors.toList());
         }

         if (StringUtils.isNotBlank(datasourceid)) {
            searchList = (List)searchList.stream().filter((log) -> log.getStrategyId().equals(datasourceid)).collect(Collectors.toList());
         }

         pageInfo.setCount((long)searchList.size());
         retList = (List)searchList.stream().skip((long)((pageno - 1) * pagesize)).limit((long)pagesize).collect(Collectors.toList());
      }

      return RespHelper.updateResp(pageInfo, retList);
   }

   @RequestMapping({"/querySqlType"})
   @ResponseBody
   public Response querySqlType(@RequestParam Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String auditlogtype = props.getProperty("auditlog_type");
      Object[] sqltypeList = null;
      if (StringUtils.isNotBlank(auditlogtype)) {
         sqltypeList = Arrays.stream(auditlogtype.split(",")).toArray();
      }

      return RespHelper.successResp(sqltypeList);
   }
}
