package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.batchmanage.BatchManage;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.BatchManageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/batchmanage"})
public class BatchManageController {
   @Autowired
   private BatchManageService batchManageService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/batchmanage/batchmanagelist";
   }

   @ResponseBody
   @RequestMapping({"/queryBatchManage"})
   public DataGridVO<BatchManage> queryBatchManage(String isstart, String engineid, String taskname, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<BatchManage> list = this.batchManageService.queryBatchManage(pageInfo);
      DataGridVO<BatchManage> vo = new DataGridVO<BatchManage>(pageInfo.getCount(), list);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/queryBatchManageAll"})
   public List<HashMap<String, String>> queryBatchManageAll(String isstart, String engineid, String taskname, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<HashMap<String, String>> listhash = new ArrayList();

      for(BatchManage batchManage : this.batchManageService.queryBatchManageAll()) {
         HashMap<String, String> map = new HashMap();
         map.put("batchdescribe", batchManage.getBatchdescribe());
         map.put("batchnumber", batchManage.getBatchnumber() + "");
         listhash.add(map);
      }

      return listhash;
   }

   @ResponseBody
   @RequestMapping({"/isrepeatnum"})
   public boolean isrepeatnum(String batchmanagenum, String batchmanageid, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (batchmanagenum != null && !"".equals(batchmanagenum)) {
         long batchManagenum = this.batchManageService.querybatchManagenum(batchmanagenum, batchmanageid);
         return batchManagenum == 0L;
      } else {
         return false;
      }
   }

   @ResponseBody
   @RequestMapping({"/saveorupdateBatchManage"})
   public void saveorupdateBatchManage(Integer batchmanagenum, String batchmanagedesc, String batchmanageid, HttpServletRequest request, HttpServletResponse response, Model model) {
      BatchManage batchManage = new BatchManage();
      batchManage.setBatchnumber(batchmanagenum);
      batchManage.setCreatetime(new Date());
      batchManage.setBatchdescribe(batchmanagedesc);
      if (batchmanageid != null && !"".equals(batchmanageid)) {
         batchManage.setId(batchmanageid);
      }

      this.batchManageService.updateorsaveBatchManage(batchManage);
   }

   @ResponseBody
   @RequestMapping({"/removeBatchManage"})
   public void removeBatchManage(String batchmanageid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.batchManageService.removeBatchManage(batchmanageid);
   }
}
