package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsEight;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsFive;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsFour;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsOne;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsSeven;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsSix;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsThree;
import com.chenyang.nse.bussiness.entity.orm.table.core.charts.TCoreChartsTwo;
import com.chenyang.nse.bussiness.entity.orm.table.core.project.TCoreProjectInfo;
import com.chenyang.nse.bussiness.service.core.CoreProjectService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/chart"})
public class ChartController {
   @Autowired
   private CoreProjectService coreProjectService;
   @Autowired
   private RedisService redisService;
   static String[] colorList = new String[]{"#1ee6b8", "#FD5916", "#01A4F7", "#2EDDCD", "#FFB6C1", "#1E90FF", "#FF0000", "#808080", "#A52A2A"};

   @RequestMapping
   public String index(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/chart/index";
   }

   @RequestMapping({"/page"})
   public String page(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/chart/" + index;
   }

   @RequestMapping({"/fullview"})
   public String fullview(String view, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("view", view);
      return "core/chart/fullview";
   }

   @ResponseBody
   @RequestMapping({"/getColumnumByRulesByProject"})
   public Map getColumnumByRulesByProject(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map map = new HashMap();
      List<String> projectNameList = new ArrayList();
      List<String> projectrealNameList = new ArrayList();
      List<TCoreProjectInfo> list = this.coreProjectService.queryAll();
      int num = 0;

      for(TCoreProjectInfo tCoreProjectInfo : list) {
         ++num;
         projectNameList.add(tCoreProjectInfo.getProjectname());
         projectrealNameList.add(tCoreProjectInfo.getRealprojectname());
      }

      List<TCoreChartsOne> tCoreChartsOnelist = this.coreProjectService.queryTCoreChartsOne(projectrealNameList);
      Set<String> ruleName = new HashSet();
      List<Map> seriesList = new ArrayList();
      HashMap<String, Integer> map_all_num = new HashMap();
      List<Integer> data_total = new ArrayList();
      HashMap<String, List<Integer>> mapdata = new HashMap();

      for(TCoreChartsOne tCoreChartsOne : tCoreChartsOnelist) {
         String rulename = tCoreChartsOne.getRulename();
         String projectname = tCoreChartsOne.getProjectid();
         Integer rulecolumnumlumnum = tCoreChartsOne.getRulecolumnum();
         if (!rulename.equals("确认非敏感字段")) {
            ruleName.add(rulename);
         }

         map_all_num.put(rulename + "~" + projectname, rulecolumnumlumnum);
      }

      List<Integer> data_t = new ArrayList();

      for(String rulename : ruleName) {
         List<Integer> datas = new ArrayList();

         for(String projectName : projectrealNameList) {
            if (map_all_num.get(rulename + "~" + projectName) != null) {
               datas.add(map_all_num.get(rulename + "~" + projectName));
            } else {
               datas.add(0);
            }
         }

         int sum_datas = datas.stream().mapToInt((str) -> str).sum();
         data_t.add(sum_datas);
         mapdata.put(rulename, datas);
      }

      int rulenum = 0;

      for(String rulename : ruleName) {
         String type = "bar";
         String color = colorList[rulenum % colorList.length];
         boolean show = false;
         String position = "insideTop";
         Map series = getColumnumByRulesByProjectSeries(rulename, type, color, show, position, (List)mapdata.get(rulename));
         seriesList.add(series);
         ++rulenum;
      }

      map.put("projectNameList", projectNameList);
      Map series = getColumnumByRulesByProjectSeries("总量", "line", "#1ED1D8", true, "top", data_total);
      seriesList.add(series);
      map.put("series", seriesList);
      return map;
   }

   @ResponseBody
   @RequestMapping({"/getColumnumByRulesByThreeProject"})
   public Map getColumnumByRulesByThreeProject(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map map = new HashMap();
      List<String> projectNameList = new ArrayList();
      List<String> projectrealNameList = new ArrayList();
      List<TCoreProjectInfo> list = this.coreProjectService.queryAll();
      int num = 0;

      for(TCoreProjectInfo tCoreProjectInfo : list) {
         projectNameList.add(tCoreProjectInfo.getProjectname());
         projectrealNameList.add(tCoreProjectInfo.getRealprojectname());
      }

      List<TCoreChartsThree> tCoreChartsThreelist = this.coreProjectService.queryTCoreChartsThree(projectrealNameList);
      List<Map> seriesList = new ArrayList();
      Set<String> ruleName = new HashSet();
      HashMap<String, Integer> map_all_num = new HashMap();
      HashMap<String, List<Integer>> mapdata = new HashMap();

      for(TCoreChartsThree tCoreChartsThree : tCoreChartsThreelist) {
         String rulename = tCoreChartsThree.getRulename();
         String projectname = tCoreChartsThree.getProjectid();
         Integer ruleaccounted = tCoreChartsThree.getRuleaccounted();
         if (!rulename.equals("确认非敏感字段")) {
            ruleName.add(rulename);
         }

         map_all_num.put(rulename + "~" + projectname, ruleaccounted);
      }

      map.put("projectNameList", projectNameList);
      map.put("legendData", ruleName);
      new ArrayList();

      for(String rulename : ruleName) {
         List<Integer> datas = new ArrayList();

         for(String projectName : projectrealNameList) {
            if (map_all_num.get(rulename + "~" + projectName) != null) {
               datas.add((Integer)map_all_num.get(rulename + "~" + projectName) == 0 ? null : (Integer)map_all_num.get(rulename + "~" + projectName));
            } else {
//               datas.add(null);
               datas.add(null);
            }
         }

         mapdata.put(rulename, datas);
      }

      int flag = 0;
      int max_num = 0;

      for(String rulename : ruleName) {
         String type = "bar";
         boolean legendHoverLink = false;
         Map series = getColumnumByRulesByThreeProjectSeries(rulename, type, colorList[flag % colorList.length], legendHoverLink, (List)mapdata.get(rulename));
         List<Integer> list_int = (List)mapdata.get(rulename);
         int sum_datas = list_int.stream().mapToInt((str) -> str == null ? 0 : str).sum();
         max_num += sum_datas;
         seriesList.add(series);
         ++flag;
      }

      map.put("series", seriesList);
      map.put("max_num", max_num);
      return map;
   }

   @ResponseBody
   @RequestMapping({"/getColumnumByRulesByFourProject"})
   public Map getColumnumByRulesByFourProject(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map map = new HashMap();
      List<String> projectNameList = new ArrayList();
      List<String> projectrealNameList = new ArrayList();
      List<TCoreProjectInfo> list = this.coreProjectService.queryAll();
      int num = 0;

      for(TCoreProjectInfo tCoreProjectInfo : list) {
         ++num;
         projectNameList.add(tCoreProjectInfo.getProjectname());
         projectrealNameList.add(tCoreProjectInfo.getRealprojectname());
      }

      map.put("projectNameList", projectNameList);
      List<TCoreChartsFour> tCoreChartsFourlist = this.coreProjectService.queryTCoreChartsFour(projectrealNameList);
      List<Map> seriesList = new ArrayList();
      Set<String> ruleName = new HashSet();
      HashMap<String, Double> map_all_num = new HashMap();
      HashMap<String, List<Double>> mapdata = new HashMap();

      for(TCoreChartsFour tCoreChartsFour : tCoreChartsFourlist) {
         String rulename = tCoreChartsFour.getRulename();
         String projectname = tCoreChartsFour.getProjectid();
         double ruleaccounted = tCoreChartsFour.getRulecolumnum();
         if (!rulename.equals("确认非敏感字段")) {
            ruleName.add(rulename);
         }

         map_all_num.put(rulename + "~" + projectname, ruleaccounted);
      }

      map.put("rulesList", ruleName);
      new ArrayList();

      for(String projectName : projectrealNameList) {
         List<Double> datas = new ArrayList();

         for(String rulename : ruleName) {
            if (map_all_num.get(rulename + "~" + projectName) != null) {
               datas.add(map_all_num.get(rulename + "~" + projectName));
            } else {
               datas.add((double)0.0F);
            }
         }

         mapdata.put(projectName, datas);
      }

      int flag = 0;

      for(String projectName : projectrealNameList) {
         Map series = new HashMap();
         series.put("value", mapdata.get(projectName));
         series.put("name", projectNameList.get(flag));
         seriesList.add(series);
         ++flag;
      }

      List<Double> dataList = new ArrayList();

      for(List<Double> valuelist : mapdata.values()) {
         for(Double value : valuelist) {
            dataList.add(value);
         }
      }

      List<Map> indicatorList = new ArrayList();

      for(String rulename : ruleName) {
         Map indicator = new HashMap();
         indicator.put("name", rulename);
         indicator.put("max", (Double)Collections.max(dataList) * 1.2);
         indicatorList.add(indicator);
      }

      map.put("indicator", indicatorList);
      map.put("seriesData", seriesList);
      return map;
   }

   @ResponseBody
   @RequestMapping({"/getColumnumByRulesByFiveProject"})
   public Map getColumnumByRulesByFiveProject(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map map = new HashMap();
      List<String> projectNameList = new ArrayList();
      List<String> projectrealNameList = new ArrayList();
      List<TCoreProjectInfo> list = this.coreProjectService.queryAll();
      int num = 0;

      for(TCoreProjectInfo tCoreProjectInfo : list) {
         ++num;
         projectNameList.add(tCoreProjectInfo.getProjectname());
         projectrealNameList.add(tCoreProjectInfo.getRealprojectname());
      }

      map.put("projectNameList", projectNameList);
      List<TCoreChartsFive> tCoreChartsFivelist = this.coreProjectService.queryTCoreChartsFive(projectrealNameList);
      Set<String> ruleName = new HashSet();
      List<Map> seriesList = new ArrayList();
      HashMap<String, Long> map_all_num = new HashMap();
      new ArrayList();
      HashMap<String, List<Long>> mapdata = new HashMap();
      new ArrayList();

      for(TCoreChartsFive tCoreChartsFive : tCoreChartsFivelist) {
         String rulename = tCoreChartsFive.getRulename();
         String projectname = tCoreChartsFive.getProjectid();
         Long rulecolumnumlumnum = tCoreChartsFive.getRulecolumnum();
         if (!rulename.equals("确认非敏感字段")) {
            ruleName.add(rulename);
         }

         map_all_num.put(rulename + "~" + projectname, rulecolumnumlumnum);
      }

      map.put("xAxis", ruleName);

      for(String projectName : projectrealNameList) {
         List<Long> datas = new ArrayList();

         for(String rulename : ruleName) {
            if (map_all_num.get(rulename + "~" + projectName) != null) {
               datas.add(map_all_num.get(rulename + "~" + projectName));
            } else {
               datas.add(0L);
            }
         }

         mapdata.put(projectName, datas);
      }

      int flag = 0;

      for(String projectName : projectrealNameList) {
         Map series = new HashMap();
         series.put("name", projectNameList.get(flag));
         series.put("type", "line");
         series.put("stack", "总量");
         series.put("type", "line");
         series.put("symbol", "circle");
         Map itemStyle = new HashMap();
         Map normal = new HashMap();
         normal.put("color", colorList[flag % colorList.length]);
         Map label = new HashMap();
         Map textStyle = new HashMap();
         textStyle.put("color", "#fff");
         label.put("textStyle", textStyle);
         normal.put("label", label);
         itemStyle.put("normal", normal);
         series.put("itemStyle", itemStyle);
         series.put("data", mapdata.get(projectName));
         seriesList.add(series);
         ++flag;
      }

      map.put("seriesData", seriesList);
      return map;
   }

   public static Map getColumnumByRulesByProjectSeries(String ruleName, String type, String color, boolean show, String position, List<Integer> data) {
      Map series = new HashMap();
      series.put("name", ruleName);
      series.put("type", type);
      series.put("stack", "总量");
      switch (type) {
         case "bar":
            series.put("barMaxWidth", 35);
            series.put("barGap", "10%");
            break;
         case "line":
            series.put("symbolSize", 10);
            series.put("symbol", "circle");
      }

      Map itemStyle = new HashMap();
      Map normal = new HashMap();
      normal.put("color", color);
      Map label = new HashMap();
      label.put("show", show);
      Map textStyle = new HashMap();
      textStyle.put("color", "#fff");
      label.put("textStyle", textStyle);
      label.put("position", position);
      normal.put("label", label);
      itemStyle.put("normal", normal);
      series.put("itemStyle", itemStyle);
      series.put("areaStyle", "{normal: {}}");
      series.put("data", data);
      return series;
   }

   public static Map getColumnumByRulesByThreeProjectSeries(String ruleName, String type, String colors, boolean legendHoverLink, List<Integer> data) {
      Map series = new HashMap();
      series.put("name", ruleName);
      series.put("type", type);
      series.put("stack", "2");
      series.put("legendHoverLink", legendHoverLink);
      series.put("barWidth", 20);
      Map itemStyle = new HashMap();
      Map normal = new HashMap();
      Map emphasis = new HashMap();
      List<String> color_arr = new ArrayList();
      color_arr.add(colors);
      color_arr.add(colors);
      color_arr.add(colors);
      normal.put("color", color_arr);
      emphasis.put("color", colors);
      itemStyle.put("normal", normal);
      itemStyle.put("emphasis", emphasis);
      series.put("itemStyle", itemStyle);
      series.put("data", data);
      return series;
   }

   @ResponseBody
   @RequestMapping({"/getDataAccountedByRulesByProject"})
   public Map getDataAccountedByRulesByProject(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map map = new HashMap();
      List<String> projectNameList = new ArrayList();
      List<String> projectrealNameList = new ArrayList();
      List<TCoreProjectInfo> list = this.coreProjectService.queryAll();
      int num = 0;

      for(TCoreProjectInfo tCoreProjectInfo : list) {
         ++num;
         projectNameList.add(tCoreProjectInfo.getProjectname());
         projectrealNameList.add(tCoreProjectInfo.getRealprojectname());
      }

      map.put("projectNameList", projectNameList);
      List<TCoreChartsTwo> tCoreChartsTwolist = this.coreProjectService.queryTCoreChartsTwo(projectrealNameList);
      HashMap<String, Integer> map_sensitiveruleaccounted_num = new HashMap();
      HashMap<String, Integer> map_nosensitiveruleaccounted_num = new HashMap();

      for(TCoreChartsTwo tCoreChartsTwo : tCoreChartsTwolist) {
         String projectname = tCoreChartsTwo.getProjectid();
         Integer Sensitiveruleaccounted = Integer.valueOf(tCoreChartsTwo.getSensitiveruleaccounted());
         Integer Nosensitiveruleaccounted = Integer.valueOf(tCoreChartsTwo.getNosensitiveruleaccounted());
         map_sensitiveruleaccounted_num.put(projectname, Sensitiveruleaccounted);
         map_nosensitiveruleaccounted_num.put(projectname, Nosensitiveruleaccounted);
      }

      List<Map> seriesList = new ArrayList();

      for(int i = 0; i < projectrealNameList.size(); ++i) {
         String leftLocation;
         String rightLocation;
         String x;
         if (i < 5) {
            leftLocation = i * 20 + 10 + "%";
            rightLocation = "30%";
            x = i * 20 + "%";
         } else {
            leftLocation = (i - 5) * 20 + 10 + "%";
            rightLocation = "70%";
            x = (i - 5) * 20 + "%";
         }

         String type = "pie";
         List<String> center = new ArrayList();
         center.add(leftLocation);
         center.add(rightLocation);
         String radius = "radius";
         String itemStyle = "labelFromatter";
         Map series = new HashMap();
         series.put("type", type);
         series.put("center", center);
         series.put("radius", radius);
         if (i > 4) {
            series.put("y", "55%");
         }

         series.put("x", x);
         series.put("itemStyle", itemStyle);
         List<Map> dataList = new ArrayList();
         Map datamap = new HashMap();
         datamap.put("name", "");
         datamap.put("value", map_nosensitiveruleaccounted_num.get(projectrealNameList.get(i)));
         datamap.put("itemStyle", "labelBottom");
         dataList.add(datamap);
         datamap = new HashMap();
         datamap.put("name", projectNameList.get(i));
         datamap.put("value", map_sensitiveruleaccounted_num.get(projectrealNameList.get(i)));
         datamap.put("itemStyle", "labelTop");
         dataList.add(datamap);
         series.put("data", dataList);
         seriesList.add(series);
      }

      map.put("series", seriesList);
      return map;
   }

   @ResponseBody
   @RequestMapping({"/getColumnumByRules"})
   public Map getColumnumByRules(String size) {
      Map map = new HashMap();
      List<String> projectNameList = new ArrayList();
      List<String> projectrealNameList = new ArrayList();

      for(TCoreProjectInfo tCoreProjectInfo : this.coreProjectService.queryAll()) {
         projectNameList.add(tCoreProjectInfo.getProjectname());
         projectrealNameList.add(tCoreProjectInfo.getRealprojectname());
      }

      map.put("projectNameList", projectNameList);
      List<TCoreChartsSix> tCoreChartsSixlist = this.coreProjectService.queryTCoreChartsSix(projectrealNameList);
      HashMap<String, TCoreChartsSix> map_s = new HashMap();

      for(TCoreChartsSix tCoreChartsSix : tCoreChartsSixlist) {
         map_s.put(tCoreChartsSix.getProjectid(), tCoreChartsSix);
      }

      int tableSum = 0;
      int sensitiveSum = 0;
      int unsensitiveSum = 0;
      List<Integer> sensitiveNum = new ArrayList();
      List<Integer> unsensitiveNum = new ArrayList();

      for(String projectrealName : projectrealNameList) {
         TCoreChartsSix tCoreChartsSix = (TCoreChartsSix)map_s.get(projectrealName);
         sensitiveNum.add(tCoreChartsSix == null ? 0 : tCoreChartsSix.getSensitivenum());
         unsensitiveNum.add(tCoreChartsSix == null ? 0 : tCoreChartsSix.getNosensitivenum());
      }

      map.put("sensitiveNum", sensitiveNum);
      map.put("unsensitiveNum", unsensitiveNum);
      return map;
   }

   @ResponseBody
   @RequestMapping({"/getColumnumByProject"})
   public Map getColumnumByProject(String size) {
      Map map = new HashMap();
      List<String> projectNameList = new ArrayList();
      List<String> projectrealNameList = new ArrayList();

      for(TCoreProjectInfo tCoreProjectInfo : this.coreProjectService.queryAll()) {
         projectNameList.add(tCoreProjectInfo.getProjectname());
         projectrealNameList.add(tCoreProjectInfo.getRealprojectname());
      }

      map.put("projectNameList", projectNameList);
      List<Integer> sensitiveNum = new ArrayList();
      List<Integer> unsensitiveNum = new ArrayList();
      List<TCoreChartsSeven> tCoreChartsSevenlist = this.coreProjectService.queryTCoreChartsSeven(projectrealNameList);
      HashMap<String, TCoreChartsSeven> map_s = new HashMap();

      for(TCoreChartsSeven tCoreChartsSeven : tCoreChartsSevenlist) {
         map_s.put(tCoreChartsSeven.getProjectid(), tCoreChartsSeven);
      }

      for(int i = 0; i < projectrealNameList.size(); ++i) {
         TCoreChartsSeven tCoreChartsSeven = (TCoreChartsSeven)map_s.get(projectrealNameList.get(i));
         Integer nosurecolumnum = tCoreChartsSeven == null ? 0 : tCoreChartsSeven.getNosurecolumnum();
         Integer surecolumnum = tCoreChartsSeven == null ? 0 : tCoreChartsSeven.getSurecolumnum();
         sensitiveNum.add(surecolumnum);
         unsensitiveNum.add(nosurecolumnum);
      }

      map.put("sensitiveNum", sensitiveNum);
      map.put("unsensitiveNum", unsensitiveNum);
      return map;
   }

   @ResponseBody
   @RequestMapping({"/getColumnumByConfirm"})
   public Map getColumnumByConfirm(String size) {
      Map map = new HashMap();
      List<String> projectNameList = new ArrayList();
      List<String> projectrealNameList = new ArrayList();

      for(TCoreProjectInfo tCoreProjectInfo : this.coreProjectService.queryAll()) {
         projectNameList.add(tCoreProjectInfo.getProjectname());
         projectrealNameList.add(tCoreProjectInfo.getRealprojectname());
      }

      List<String> dataNosurecolumnum = new ArrayList();
      List<String> dataSurecolumnum = new ArrayList();
      List<String> dataAllcolumnum = new ArrayList();
      List<TCoreChartsEight> tCoreChartsEightlist = this.coreProjectService.queryTCoreChartsEight(projectrealNameList);
      HashMap<String, TCoreChartsEight> map_s = new HashMap();

      for(TCoreChartsEight tCoreChartsEight : tCoreChartsEightlist) {
         map_s.put(tCoreChartsEight.getProjectid(), tCoreChartsEight);
      }

      for(int i = 0; i < projectrealNameList.size(); ++i) {
         TCoreChartsEight tCoreChartsEight = (TCoreChartsEight)map_s.get(projectrealNameList.get(i));
         String nosurecolumnum = tCoreChartsEight == null ? "0" : tCoreChartsEight.getNosurecolumnum();
         String surecolumnum = tCoreChartsEight == null ? "0" : tCoreChartsEight.getSurecolumnum();
         String allcolumnum = tCoreChartsEight == null ? "0" : tCoreChartsEight.getAllcolumnum();
         dataNosurecolumnum.add(nosurecolumnum);
         dataSurecolumnum.add(surecolumnum);
         dataAllcolumnum.add(allcolumnum);
      }

      map.put("projectNameList", projectNameList);
      map.put("confirmTotal", dataAllcolumnum);
      map.put("dataNosurecolumnum", dataNosurecolumnum);
      map.put("dataSurecolumnum", dataSurecolumnum);
      return map;
   }

   @RequestMapping({"/classification"})
   public String classification(String view, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("view", view);
      return "/core/datascope/chart/classification";
   }

   @RequestMapping({"/fullview_s"})
   public String fullview_s(String view, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("view", view);
      return "/core/datascope/chart/fullview";
   }

   @ResponseBody
   @RequestMapping({"/jumpurl"})
   public String jumpurl(String chartype, String value, HttpServletRequest request, HttpServletResponse response, Model model) {
      String[] var10000 = new String[]{"levelBycolumn", "projectBylevelBycolumn", "complianceBycolumn", "projectBycomplianceBycolumn", "datatangeBycolumn", "projectBydatatangeBycolumn"};
      new ArrayList();
      String projectid = "";
      String type = "";
      String url = "";
      switch (chartype) {
         case "complianceBycolumn":
            url = "/core/rulereport/getdescriptionpage?type=0&project_name=null";
            break;
         case "levelBycolumn":
            url = "/core/rulereport/getdescriptionpage?type=2&project_name=null";
            break;
         case "datatangeBycolumn":
            url = "/core/rulereport/getdescriptionpage?type=1&project_name=null";
            break;
         case "projectBylevelBycolumn":
            url = "/core/rulereport?type=2";
            break;
         case "projectBycomplianceBycolumn":
            List<TCoreProjectInfo> var13 = this.coreProjectService.queryByName(value);
            if (var13 != null && var13.size() != 0) {
               projectid = ((TCoreProjectInfo)var13.get(0)).getRealprojectname();
            }

            url = "/core/rulereport?type=0";
            break;
         case "projectBydatatangeBycolumn":
            List<TCoreProjectInfo> tCoreProjectInfolist = this.coreProjectService.queryByName(value);
            if (tCoreProjectInfolist != null && tCoreProjectInfolist.size() != 0) {
               projectid = ((TCoreProjectInfo)tCoreProjectInfolist.get(0)).getRealprojectname();
            }

            url = "/core/rulereport?type=1";
      }

      return url;
   }

   @ResponseBody
   @RequestMapping({"/getcomplianceBycolumn"})
   public Map getcomplianceBycolumn(String size) {
      Map map = new HashMap();
      String type = "";
      Map<String, List<String>> namemap = new HashMap();
      Map<String, List<String>> columnNamemap = new HashMap();
      Map<String, List<Map<String, String>>> valueNameListMap = new HashMap();
      Map<String, List<Map>> valueNameListMap1 = new HashMap();
      List<Integer> dataL = new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      String[] name_array = new String[]{"levelBycolumn", "complianceBycolumn", "datatangeBycolumn"};
      String[] name_array1 = new String[]{"projectBylevelBycolumn", "projectBycomplianceBycolumn", "projectBydatatangeBycolumn"};

      for(String name : name_array) {
         List<Map<String, String>> valueNameList = new ArrayList();
         List<String> nameList = (List)this.redisService.get(name + "_key_list");
         List<String> columnNameList = (List)this.redisService.get(name + "_value_list");
         if (nameList == null) {
            nameList = new ArrayList();
         }

         if (columnNameList == null) {
            columnNameList = new ArrayList();
         }

         String[] nameList_strings = new String[nameList.size()];
         String[] columnNameList_strings = new String[columnNameList.size()];
         nameList.toArray(nameList_strings);
         columnNameList.toArray(columnNameList_strings);

         for(int i = 0; i < columnNameList_strings.length - 1; ++i) {
            for(int j = 0; j < columnNameList_strings.length - 1 - i; ++j) {
               if (Integer.parseInt(columnNameList_strings[j] == null ? "0" : columnNameList_strings[j]) < Integer.parseInt(columnNameList_strings[j + 1] == null ? "0" : columnNameList_strings[j + 1])) {
                  String temp = columnNameList_strings[j];
                  columnNameList_strings[j] = columnNameList_strings[j + 1];
                  columnNameList_strings[j + 1] = temp;
                  String temp1 = nameList_strings[j];
                  nameList_strings[j] = nameList_strings[j + 1];
                  nameList_strings[j + 1] = temp1;
               }
            }
         }

         nameList = Arrays.asList(nameList_strings);
         columnNameList = Arrays.asList(columnNameList_strings);
         if (!nameList.isEmpty()) {
            for(int k = 0; k < nameList.size(); ++k) {
               Map<String, String> vnmap = new HashMap();
               vnmap.put("value", columnNameList_strings[k]);
               vnmap.put("name", nameList_strings[k]);
               valueNameList.add(vnmap);
            }
         }

         namemap.put(name, nameList);
         columnNamemap.put(name, columnNameList);
         valueNameListMap.put(name, valueNameList);
      }

      for(String name : name_array1) {
         List<String> ruleName = new ArrayList();
         List<String> nameList1 = (List)this.redisService.get(name + "_key_list");
         List<Map<String, List<Integer>>> columnNameList1 = (List)this.redisService.get(name + "_value_list");
         if (nameList1 == null) {
            nameList1 = new ArrayList();
         }

         if (columnNameList1 == null) {
            columnNameList1 = new ArrayList();
         }

         switch (name) {
            case "projectBylevelBycolumn":
               ruleName = (List)this.redisService.get("levelBycolumn_key_list");
               type = "bar";
               break;
            case "projectBycomplianceBycolumn":
               ruleName = (List)this.redisService.get("complianceBycolumn_key_list");
               type = "line";
               break;
            case "projectBydatatangeBycolumn":
               ruleName = (List)this.redisService.get("datatangeBycolumn_key_list");
               type = "bar";
         }

         int rulenum = 0;
         List<Map> seriesList = new ArrayList();

         for(String rulename : ruleName) {
            for(Map<String, List<Integer>> nameL : columnNameList1) {
               for(String keyL : nameL.keySet()) {
                  if (rulename.equals(keyL)) {
                     dataL = (List)nameL.get(keyL);
                  }
               }
            }

            String color = "";
            boolean show = false;
            String position = "insideTop";
            Map series = getColumnumByRulesByProjectSeries(rulename, type, color, show, position, dataL);
            seriesList.add(series);
            ++rulenum;
         }

         namemap.put(name, nameList1);
         valueNameListMap1.put(name, seriesList);
      }

      map.put("xdatalist", namemap);
      map.put("datalist", columnNamemap);
      map.put("vnList", valueNameListMap);
      map.put("vnList1", valueNameListMap1);
      return map;
   }
}
