package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.vo.ControlledAssertVO;
import com.chenyang.nse.bussiness.service.core.ControlledAssetService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@EnableAsync
@Controller
@RequestMapping({"/core/controlledasset"})
public class ControlledAssetController {
   private static Logger logger = LoggerFactory.getLogger(ControlledAssetController.class);
   @Autowired
   private ControlledAssetService controlledAssetService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @RequestMapping({"/query"})
   @ResponseBody
   public Response query(@RequestParam Map<String, String> params, Integer pageno, Integer pagesize, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(pageno);
      pageInfo.setPagesize(pagesize);
      List<ControlledAssertVO> list = this.controlledAssetService.queryControlledAsset(pageInfo, params);
      ddmauditLogger.info(MesUtil.getMsg("DDM_01302", new String[]{CommonUtils.loginUsername(), CommonUtils.loginUsername()}));
      return RespHelper.updateResp(pageInfo, list);
   }

   @RequestMapping({"/initEdit"})
   @ResponseBody
   public Response<ControlledAssertVO> initControlledAsset(@RequestParam Map<String, String> params) {
      String id = String.valueOf(params.get("id"));
      ddmauditLogger.info(MesUtil.getMsg("DDM_01304", new String[]{CommonUtils.loginUsername(), CommonUtils.loginUsername()}));
      if (id != null && id.toString().length() != 0) {
         ControlledAssertVO assertVO = this.controlledAssetService.initControlledAsset(id);
         return RespHelper.<ControlledAssertVO>successResp(assertVO);
      } else {
         return RespHelper.<ControlledAssertVO>paramErrResp();
      }
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response<ControlledAssertVO> addControlledAsset(@RequestBody ControlledAssertVO controlledAssertVO, HttpServletRequest request) {
      if (StringUtils.isBlank(controlledAssertVO.getId()) && !ObjectUtils.isEmpty(this.controlledAssetService.queryByName(controlledAssertVO.getName()))) {
         return RespHelper.<ControlledAssertVO>createResp(false, "POP_00026", MesUtil.getMsg("POP_00026", new String[0]));
      } else {
         if (StringUtils.isBlank(controlledAssertVO.getId())) {
            ddmauditLogger.info(MesUtil.getMsg("DDM_01304", new String[]{CommonUtils.loginUsername(), controlledAssertVO.getName()}));
         } else {
            ddmauditLogger.info(MesUtil.getMsg("DDM_01303", new String[]{CommonUtils.loginUsername(), controlledAssertVO.getName()}));
         }

         this.controlledAssetService.addControlledAsset(controlledAssertVO, request);
         return RespHelper.<ControlledAssertVO>successResp(controlledAssertVO);
      }
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response remove(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = (String)params.get("id");
      String name = (String)params.get("name");
      ddmauditLogger.info(MesUtil.getMsg("DDM_01305", new String[]{CommonUtils.loginUsername(), name}));
      this.controlledAssetService.remove(id);
      this.controlledAssetService.deleteAreaByAssetid(id);
      this.controlledAssetService.deleteRuleByAssetid(id);
      return RespHelper.successResp();
   }
}
