package com.chenyang.nse.bussiness.controller.core.log.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/log/app/appexecutelog"})
public class AppExecuteLogController {
   @GetMapping({"/getapplog"})
   @ResponseBody
   public Response getauditlog(@RequestParam("date") String date, @RequestParam("type") String type) throws IOException {
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String filepath = props.getProperty("appserverlogpath");
      String typename = "";
      JSONArray jsonArray = new JSONArray();
      if ("1".equals(type)) {
         typename = "masking";
      } else if ("2".equals(type)) {
         typename = "audit";
      }

      String path = filepath + File.separator + typename + File.separator + date + ".txt";
      File file = new File(path);
      BufferedReader reader = null;
      reader = new BufferedReader(new FileReader(file));
      String linestr = null;

      while((linestr = reader.readLine()) != null) {
         JSONObject jsonObject = JSONObject.parseObject(linestr);
         jsonArray.add(jsonObject);
      }

      return RespHelper.successResp(jsonArray);
   }
}
