package com.chenyang.nse.bussiness.controller.core.rule;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.app.AppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.ApplicationConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.DateConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.DbuserConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.IpConditions;
import com.chenyang.nse.bussiness.service.core.AppDataRuleService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/rule/appdatarule"})
public class AppDataRuleController {
   @Autowired
   private AppDataRuleService appDataRuleService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @PostMapping({"/add"})
   @ResponseBody
   public Response appDataRuleAdd(@RequestBody Map<String, Object> params) {
      AppDataRule ruleinfo = (AppDataRule)ObjectTool.getObjectByMap(AppDataRule.class, (Map)params.get("ruleinfo"));
      String id = ruleinfo.getId();
      AppDataRule appDataRule = new AppDataRule();
      BeanUtils.copyProperties(ruleinfo, appDataRule);
      if (StringUtil.isBlank(id)) {
         appDataRule.setId(UUID.randomUUID().toString());
         ddmauditLogger.info(MesUtil.getMsg("DDM_01401", new String[]{CommonUtils.loginUsername(), ruleinfo.getRulename()}));
      } else {
         this.appDataRuleService.delIpConditionsInfoByRuleId(id);
         this.appDataRuleService.delApplicationConditionsInfoByRuleId(id);
         this.appDataRuleService.delDbuserConditionsInfoByRuleId(id);
         this.appDataRuleService.delDateConditionsInfoByRuleId(id);
         ddmauditLogger.info(MesUtil.getMsg("DDM_01403", new String[]{CommonUtils.loginUsername(), ruleinfo.getRulename()}));
      }

      List ipconditionslist = (List)params.get("ipconditionslist");
      ipconditionslist.forEach((ipconditions) -> {
         IpConditions ipcs = (IpConditions)ObjectTool.getObjectByMap(IpConditions.class, (Map)ipconditions);
         IpConditions ipConditions = new IpConditions();
         BeanUtils.copyProperties(ipcs, ipConditions);
         ipConditions.setRuleid(appDataRule.getId());
         this.appDataRuleService.saveIpConditionsInfo(ipConditions);
      });
      List applicationconditionslist = (List)params.get("applicationconditionslist");
      applicationconditionslist.forEach((applicationconditions) -> {
         ApplicationConditions appcs = (ApplicationConditions)ObjectTool.getObjectByMap(ApplicationConditions.class, (Map)applicationconditions);
         ApplicationConditions applicationConditions = new ApplicationConditions();
         BeanUtils.copyProperties(appcs, applicationConditions);
         applicationConditions.setRuleid(appDataRule.getId());
         this.appDataRuleService.saveApplicationConditionsInfo(applicationConditions);
      });
      List dbuserconditionslist = (List)params.get("dbuserconditionslist");
      dbuserconditionslist.forEach((dbuserconditions) -> {
         DbuserConditions dbusercs = (DbuserConditions)ObjectTool.getObjectByMap(DbuserConditions.class, (Map)dbuserconditions);
         DbuserConditions dbuserConditions = new DbuserConditions();
         BeanUtils.copyProperties(dbusercs, dbuserConditions);
         dbuserConditions.setRuleid(appDataRule.getId());
         this.appDataRuleService.saveDbuserConditionsInfo(dbuserConditions);
      });
      List dateconditionslist = (List)params.get("dateconditionslist");
      dateconditionslist.forEach((dateconditions) -> {
         DateConditions datecs = (DateConditions)ObjectTool.getObjectByMap(DateConditions.class, (Map)dateconditions);
         DateConditions dateConditions = new DateConditions();
         BeanUtils.copyProperties(datecs, dateConditions);
         dateConditions.setRuleid(appDataRule.getId());
         this.appDataRuleService.saveDateConditionsInfo(dateConditions);
      });
      this.appDataRuleService.saveAppRuleInfo(appDataRule, id);
      return RespHelper.successResp();
   }

   @GetMapping({"/initEdit"})
   @ResponseBody
   public Response appDataRuleInitEdit(@RequestParam("ruleid") String id, @RequestParam("rulename") String rulename) {
      ddmauditLogger.info(MesUtil.getMsg("DDM_01402", new String[]{CommonUtils.loginUsername(), rulename}));
      AppDataRule appRuleInfo = this.appDataRuleService.getAppRuleInfoById(id);
      List<IpConditions> ipConditionsList = this.appDataRuleService.getIpConditionsInfoByRuleId(id);
      List<ApplicationConditions> applicationConditionsList = this.appDataRuleService.getApplicationConditionsInfoByRuleId(id);
      List<DbuserConditions> dbuserConditionsList = this.appDataRuleService.getDbuserConditionsInfoByRuleId(id);
      List<DateConditions> dateConditionsList = this.appDataRuleService.getDateConditionsInfoByRuleId(id);
      Map<String, Object> map = new HashMap();
      map.put("ruleinfo", appRuleInfo);
      map.put("ipConditions", ipConditionsList);
      map.put("applicationConditions", applicationConditionsList);
      map.put("dbuserConditions", dbuserConditionsList);
      map.put("dateConditions", dateConditionsList);
      return RespHelper.successResp(map);
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response appDataRuleDel(@RequestBody Map<String, Object> params) {
      String id = (String)params.get("ruleid");
      String rulename = (String)params.get("rulename");
      ddmauditLogger.info(MesUtil.getMsg("DDM_01404", new String[]{CommonUtils.loginUsername(), rulename}));
      this.appDataRuleService.delAppRuleInfoById(id);
      this.appDataRuleService.delIpConditionsInfoByRuleId(id);
      this.appDataRuleService.delApplicationConditionsInfoByRuleId(id);
      this.appDataRuleService.delDbuserConditionsInfoByRuleId(id);
      this.appDataRuleService.delDateConditionsInfoByRuleId(id);
      return RespHelper.successResp();
   }

   @GetMapping({"/query"})
   @ResponseBody
   public Response appDataRuleQuery() {
      ddmauditLogger.info(MesUtil.getMsg("DDM_01400", new String[]{CommonUtils.loginUsername()}));
      return RespHelper.successResp(this.appDataRuleService.queryAll());
   }
}
