package com.chenyang.nse.bussiness.controller.core.strategy.audit;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.app.AuditAppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditApplicationConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditDateConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditDbuserConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditIpConditions;
import com.chenyang.nse.bussiness.service.core.strategy.AuditAppDataRuleService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/audit/appdatarule"})
public class AuditAppDataRuleController {
   @Autowired
   private AuditAppDataRuleService auditAppDataRuleService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @PostMapping({"/add"})
   @ResponseBody
   public Response auditDataRuleAdd(@RequestBody Map<String, Object> params) {
      AuditAppDataRule ruleinfo = (AuditAppDataRule)ObjectTool.getObjectByMap(AuditAppDataRule.class, (Map)params.get("ruleinfo"));
      String id = ruleinfo.getId();
      AuditAppDataRule appDataRule = new AuditAppDataRule();
      BeanUtils.copyProperties(ruleinfo, appDataRule);
      if (StringUtil.isBlank(id)) {
         appDataRule.setId(UUID.randomUUID().toString());
         ddmauditLogger.info(MesUtil.getMsg("DDM_01601", new String[]{CommonUtils.loginUsername(), ruleinfo.getRulename()}));
      } else {
         this.auditAppDataRuleService.delIpConditionsInfoByRuleId(id);
         this.auditAppDataRuleService.delApplicationConditionsInfoByRuleId(id);
         this.auditAppDataRuleService.delDbuserConditionsInfoByRuleId(id);
         this.auditAppDataRuleService.delDateConditionsInfoByRuleId(id);
         ddmauditLogger.info(MesUtil.getMsg("DDM_01603", new String[]{CommonUtils.loginUsername(), ruleinfo.getRulename()}));
      }

      List ipconditionslist = (List)params.get("ipconditionslist");
      ipconditionslist.forEach((ipconditions) -> {
         AuditIpConditions ipcs = (AuditIpConditions)ObjectTool.getObjectByMap(AuditIpConditions.class, (Map)ipconditions);
         AuditIpConditions ipConditions = new AuditIpConditions();
         BeanUtils.copyProperties(ipcs, ipConditions);
         ipConditions.setRuleid(appDataRule.getId());
         this.auditAppDataRuleService.saveIpConditionsInfo(ipConditions);
      });
      List applicationconditionslist = (List)params.get("applicationconditionslist");
      applicationconditionslist.forEach((applicationconditions) -> {
         AuditApplicationConditions appcs = (AuditApplicationConditions)ObjectTool.getObjectByMap(AuditApplicationConditions.class, (Map)applicationconditions);
         AuditApplicationConditions applicationConditions = new AuditApplicationConditions();
         BeanUtils.copyProperties(appcs, applicationConditions);
         applicationConditions.setRuleid(appDataRule.getId());
         this.auditAppDataRuleService.saveApplicationConditionsInfo(applicationConditions);
      });
      List dbuserconditionslist = (List)params.get("dbuserconditionslist");
      dbuserconditionslist.forEach((dbuserconditions) -> {
         AuditDbuserConditions dbusercs = (AuditDbuserConditions)ObjectTool.getObjectByMap(AuditDbuserConditions.class, (Map)dbuserconditions);
         AuditDbuserConditions dbuserConditions = new AuditDbuserConditions();
         BeanUtils.copyProperties(dbusercs, dbuserConditions);
         dbuserConditions.setRuleid(appDataRule.getId());
         this.auditAppDataRuleService.saveDbuserConditionsInfo(dbuserConditions);
      });
      List dateconditionslist = (List)params.get("dateconditionslist");
      dateconditionslist.forEach((dateconditions) -> {
         AuditDateConditions datecs = (AuditDateConditions)ObjectTool.getObjectByMap(AuditDateConditions.class, (Map)dateconditions);
         AuditDateConditions dateConditions = new AuditDateConditions();
         BeanUtils.copyProperties(datecs, dateConditions);
         dateConditions.setRuleid(appDataRule.getId());
         this.auditAppDataRuleService.saveDateConditionsInfo(dateConditions);
      });
      this.auditAppDataRuleService.saveAppRuleInfo(appDataRule, id);
      return RespHelper.successResp();
   }

   @GetMapping({"/initEdit"})
   @ResponseBody
   public Response auditDataRuleInitEdit(@RequestParam("id") String id, @RequestParam("name") String name) {
      ddmauditLogger.info(MesUtil.getMsg("DDM_01602", new String[]{CommonUtils.loginUsername(), name}));
      List<AuditAppDataRule> appRuleInfo = this.auditAppDataRuleService.getAppRuleInfoById(id);
      List<AuditIpConditions> ipConditionsList = this.auditAppDataRuleService.getIpConditionsInfoByRuleId(id);
      List<AuditApplicationConditions> applicationConditionsList = this.auditAppDataRuleService.getApplicationConditionsInfoByRuleId(id);
      List<AuditDbuserConditions> dbuserConditionsList = this.auditAppDataRuleService.getDbuserConditionsInfoByRuleId(id);
      List<AuditDateConditions> dateConditionsList = this.auditAppDataRuleService.getDateConditionsInfoByRuleId(id);
      Map<String, Object> map = new HashMap();
      map.put("ruleinfo", appRuleInfo.get(0));
      map.put("ipConditions", ipConditionsList);
      map.put("applicationConditions", applicationConditionsList);
      map.put("dbuserConditions", dbuserConditionsList);
      map.put("dateConditions", dateConditionsList);
      return RespHelper.successResp(map);
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response auditDataRuleDel(@RequestBody Map<String, Object> params) {
      String id = (String)params.get("id");
      String rulename = (String)params.get("name");
      ddmauditLogger.info(MesUtil.getMsg("DDM_01604", new String[]{CommonUtils.loginUsername(), rulename}));
      this.auditAppDataRuleService.delAppRuleInfoById(id);
      this.auditAppDataRuleService.delIpConditionsInfoByRuleId(id);
      this.auditAppDataRuleService.delApplicationConditionsInfoByRuleId(id);
      this.auditAppDataRuleService.delDbuserConditionsInfoByRuleId(id);
      this.auditAppDataRuleService.delDateConditionsInfoByRuleId(id);
      return RespHelper.successResp();
   }

   @GetMapping({"/query"})
   @ResponseBody
   public Response auditDataRuleQuery() {
      ddmauditLogger.info(MesUtil.getMsg("DDM_01301", new String[]{CommonUtils.loginUsername()}));
      return RespHelper.successResp(this.auditAppDataRuleService.queryAll());
   }
}
