package com.chenyang.nse.bussiness.controller.restfulapi.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.beans.BeanMap;

public class ApiTool {
   public static final String RT_SUC_CODE_200_STR = "200";
   public static final String RT_FAIL_CODE_400_STR = "400";

   public static <T> Map<String, Object> beanToMap(T bean) {
      Map<String, Object> map = Maps.newHashMap();
      if (bean != null) {
         BeanMap beanMap = BeanMap.create(bean);

         for(Object key : beanMap.keySet()) {
            map.put(key + "", beanMap.get(key));
         }
      }

      return map;
   }

   public static <T> T mapToBean(Map<String, Object> map, T bean) {
      BeanMap beanMap = BeanMap.create(bean);
      beanMap.putAll(map);
      return bean;
   }

   public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
      List<Map<String, Object>> list = Lists.newArrayList();
      if (objList != null && objList.size() > 0) {
         Map<String, Object> map = null;
         T bean = null;
         int i = 0;

         for(int size = objList.size(); i < size; ++i) {
            bean = (T)objList.get(i);
            map = beanToMap(bean);
            list.add(map);
         }
      }

      return list;
   }

   public static List<Map<String, Object>> realObjectsToMaps(List<Object> objList) {
      List<Map<String, Object>> list = Lists.newArrayList();
      if (objList != null && objList.size() > 0) {
         Map<String, Object> map = new HashMap();
         Object bean = null;
         int i = 0;

         for(int size = objList.size(); i < size; ++i) {
            bean = objList.get(i);
            map.put("data", bean);
            list.add(map);
         }
      }

      return list;
   }
}
