package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreComplianceDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.vo.datascope.AssignmentNameVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class AssignmentNameDao extends BaseDao<Object, String> {
   public List<AssignmentNameVO> assignmentNameVO(PageInfo pageInfo, String taskname) {
      String sql = XmlTool.getSql("assignmentname", "selectAssignmentNameList");
      System.out.println(taskname);
      List<AssignmentNameVO> vo = this.getSession().createNativeQuery(sql).setParameter("tname", taskname).setResultTransformer(Transformers.aliasToBean(AssignmentNameVO.class)).getResultList();
      return vo;
   }

   public int insertscopefield(String scope_field) {
      String sql = "INSERT INTO t_core_scope_field(id,tablefield_id,assignment_id,scope_id) VALUES " + scope_field;
      return this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public int insertdirectoryfield(String directory_field) {
      String sql = "INSERT INTO t_core_field_directory(id,tablefield_id,assignment_id,directory_id) VALUES " + directory_field;
      return this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public int insertsensitivefield(String sensitive_field) {
      String sql = "INSERT INTO t_core_field_sensitive(id,tablefield_id,assignment_id,sensitive_id) VALUES " + sensitive_field;
      return this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public List<TCoreDataScope> getDataScopeList(String id) {
      String sql = "select t.scope_name,t.scope_id from t_core_scope_field f,t_core_data_scope t where t.scope_id= f.scope_id and f.tablefield_id = '" + id + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreDataScope.class)).getResultList();
   }

   public List<TCoreComplianceDirectory> getComplianceDirectoryList(String id) {
      String sql = "select t.directory_name directory_name,t.id id from t_core_field_directory f,t_core_compliance_directory t where t.id = f.directory_id and f.tablefield_id = '" + id + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreComplianceDirectory.class)).getResultList();
   }

   public List<TCoreSensitiveLevel> getSensitiveLevel(String id) {
      String sql = "select t.sensitive_name sensitive_name,t.id id from t_core_field_sensitive f,t_core_sensitive_level t where t.id = f.sensitive_id and f.tablefield_id = '" + id + "'";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreSensitiveLevel.class)).getResultList();
   }
}
