package com.chenyang.nse.bussiness.dao.table.core.api;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.vo.api.AccountabilityVO;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class AccountabilityAPIDao extends BaseDao<AccountabilityVO, String> {
   public List<AccountabilityVO> selectAccountabilityInfo(String datasystemid) {
      String sql = "select duty_id,duty_name,duty_scope,duty_main,d.sysname FROM t_duty_person p JOIN t_core_datasystem d ON d.id = p.datasystemid WHERE datasystemid =:datasystemid ";
      return this.getSession().createNativeQuery(sql).setParameter("datasystemid", datasystemid).setResultTransformer(Transformers.aliasToBean(AccountabilityVO.class)).getResultList();
   }

   public List<AccountabilityVO> selectAccountabilityInfo(String projectid, String datasystemid, String taskid) {
      String sql = "SELECT schemaname ,tablename ,joinid,jointype FROM t_console_dutytableinfo d LEFT JOIN t_console_dutyjoininfo i ON i.dutytableid = d.id\r\nWHERE d.projectid = :projectid AND d.datasystemid = :datasystemid AND d.id=:taskid";
      return this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setParameter("datasystemid", datasystemid).setParameter("taskid", taskid).setResultTransformer(Transformers.aliasToBean(AccountabilityVO.class)).getResultList();
   }
}
