package com.chenyang.nse.bussiness.dao.table.core.controlled;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreControlledAsset;
import com.chenyang.nse.bussiness.entity.vo.ControlledAssertVO;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class ControlledAssetDao extends BaseDao<TCoreControlledAsset, String> {
   static final String CACHE_NAME = "tcoredesensitization";

   public List<ControlledAssertVO> queryAssertbyId(String id) {
      String sql = "SELECT u.id as id,u.name, u.type, u.datasourceid, u.datasourcename, u.dbtype, u.business, u.note FROM t_core_controlled_asset u where u.id = :id";
      return this.getSession().createNativeQuery(sql).setParameter("id", id).setResultTransformer(Transformers.aliasToBean(ControlledAssertVO.class)).getResultList();
   }

   public TCoreControlledAsset queryByName(String name) {
      Criterion cusername = Restrictions.eq("name", name);
      return (TCoreControlledAsset)this.queryUnique(new Criterion[]{cusername});
   }

   public TCoreControlledAsset queryByDatasourceid(String datasourceid) {
      Criterion cusername = Restrictions.eq("datasourceid", datasourceid);
      return (TCoreControlledAsset)this.queryUnique(new Criterion[]{cusername});
   }

   public List<Map<String, Object>> queryAreaNum2RuleNum() {
      String sql = "select b.id, count(b.areaId) as areanum, count(b.ruleId) as rulenum from (  SELECT u.id AS id,a.id as areaId,r.id as ruleId FROM  t_core_controlled_asset u LEFT JOIN t_core_controlled_asset_area a ON u.id = a.assetid  LEFT JOIN t_core_controlled_asset_rule r ON u.id = r.assetid ) b group by b.id ";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }
}
