package com.chenyang.nse.bussiness.init;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class CorsConfig implements WebMvcConfigurer {
   static final String[] ORIGINS = new String[]{"GET", "POST", "PUT", "DELETE"};

   public void addCorsMappings(CorsRegistry registry) {
      registry.addMapping("/**").allowedOriginPatterns(new String[]{"*"}).allowedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"}).allowCredentials(true).maxAge(3600L).allowedHeaders(new String[]{"*"});
   }
}
