package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.table.base.TBaseButtonDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseButton;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.service.console.ButtonService;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ButtonServiceImpl implements ButtonService {
   @Autowired
   private TBaseButtonDao tBaseButtonDao;

   public boolean checkNameExit(String menuid, String buttonname) {
      Criterion cmenuid = Restrictions.eq("menuid", menuid);
      Criterion cbuttonname = Restrictions.eq("buttonname", buttonname);
      long count = this.tBaseButtonDao.count(new Criterion[]{cmenuid, cbuttonname});
      return count > 0L;
   }

   public void save(TBaseButton button) {
      if (button.getId() == null) {
         button.setId(StringTool.getTablePrimaryKey());
         this.tBaseButtonDao.save(button);
      } else {
         this.tBaseButtonDao.saveOrUpdate(button);
      }

   }

   public List<String> queryDistinctMenuId() {
      List<String> list = this.tBaseButtonDao.getDistinctMenuId();
      return list;
   }

   public List<TBaseButton> queryButtonByParentId(String parentid) {
      Criterion cpid = Restrictions.eq("menuid", parentid);
      return this.tBaseButtonDao.queryAll(new Criterion[]{cpid});
   }

   public TBaseButton queryButtonById(String id) {
      Criterion ctid = Restrictions.eq("id", id);
      return id != null ? (TBaseButton)this.tBaseButtonDao.queryUnique(new Criterion[]{ctid}) : null;
   }

   public void deletebutton(String id) {
      this.tBaseButtonDao.removeById(id);
   }

   public String checkUrlExit(String url) {
      List<TBaseButton> urllist = this.tBaseButtonDao.queryAll(new Criterion[]{Restrictions.eq("operatename", url)});
      return urllist.size() > 0 ? "0" : "1";
   }

   public List<TBaseButton> queryButtonCRUDByRoleids(List<TBaseRole> roleids) {
      List<String> roles = new ArrayList();

      for(TBaseRole role : roleids) {
         roles.add(role.getId());
      }

      return this.tBaseButtonDao.queryButtonCRUDByRoleids(roles);
   }

   public List<TBaseButton> queryButtonNotCRUDByRoleids(List<TBaseRole> roleids) {
      List<String> roles = new ArrayList();

      for(TBaseRole role : roleids) {
         roles.add(role.getId());
      }

      return this.tBaseButtonDao.queryButtonNotCRUDByRoleids(roles);
   }
}
