package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.rule.app.AppDataRuleDao;
import com.chenyang.nse.bussiness.dao.table.core.rule.conditions.ApplicationConditionsDao;
import com.chenyang.nse.bussiness.dao.table.core.rule.conditions.DateConditionsDao;
import com.chenyang.nse.bussiness.dao.table.core.rule.conditions.DbuserConditionsDao;
import com.chenyang.nse.bussiness.dao.table.core.rule.conditions.IpConditionsDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.app.AppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.ApplicationConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.DateConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.DbuserConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.IpConditions;
import com.chenyang.nse.bussiness.service.core.AppDataRuleService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppDataRuleServiceImpl implements AppDataRuleService {
   @Autowired
   private AppDataRuleDao appDataRuleDao;
   @Autowired
   private IpConditionsDao ipConditionsDao;
   @Autowired
   private ApplicationConditionsDao applicationConditionsDao;
   @Autowired
   private DbuserConditionsDao dbuserConditionsDao;
   @Autowired
   private DateConditionsDao dateConditionsDao;

   public void saveAppRuleInfo(AppDataRule appDataRule, String id) {
      if (StringUtil.isBlank(id)) {
         appDataRule.setCreateuser(CommonUtils.loginUsername());
         appDataRule.setCreatetime(new Date());
         this.appDataRuleDao.save(appDataRule);
      } else {
         appDataRule.setUpdateuser(CommonUtils.loginUsername());
         appDataRule.setUpdatetime(new Date());
         AppDataRule appDataRule1 = (AppDataRule)this.appDataRuleDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
         BeanUtils.copyProperties(appDataRule, appDataRule1);
         this.appDataRuleDao.update(appDataRule1);
      }

   }

   public void saveIpConditionsInfo(IpConditions ipConditions) {
      this.ipConditionsDao.save(ipConditions);
   }

   public void saveApplicationConditionsInfo(ApplicationConditions applicationConditions) {
      this.applicationConditionsDao.save(applicationConditions);
   }

   public void saveDbuserConditionsInfo(DbuserConditions dbuserConditions) {
      this.dbuserConditionsDao.save(dbuserConditions);
   }

   public void saveDateConditionsInfo(DateConditions dateConditions) {
      this.dateConditionsDao.save(dateConditions);
   }

   public AppDataRule getAppRuleInfoById(String id) {
      return (AppDataRule)this.appDataRuleDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
   }

   public List<IpConditions> getIpConditionsInfoByRuleId(String ruleid) {
      return this.ipConditionsDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public List<ApplicationConditions> getApplicationConditionsInfoByRuleId(String ruleid) {
      return this.applicationConditionsDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public List<DbuserConditions> getDbuserConditionsInfoByRuleId(String ruleid) {
      return this.dbuserConditionsDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public List<DateConditions> getDateConditionsInfoByRuleId(String ruleid) {
      return this.dateConditionsDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public void delAppRuleInfoById(String id) {
      this.appDataRuleDao.removeById(id);
   }

   public void delIpConditionsInfoByRuleId(String ruleid) {
      this.ipConditionsDao.remove(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public void delApplicationConditionsInfoByRuleId(String ruleid) {
      this.applicationConditionsDao.remove(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public void delDbuserConditionsInfoByRuleId(String ruleid) {
      this.dbuserConditionsDao.remove(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public void delDateConditionsInfoByRuleId(String ruleid) {
      this.dateConditionsDao.remove(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public List<AppDataRule> queryAll() {
      return this.appDataRuleDao.queryAll();
   }

   public List<AppDataRule> queryRuleBygroup(String dataareaid, String dbtype) {
      return this.appDataRuleDao.queryAll(new Criterion[]{Restrictions.or(Restrictions.eq("belongtogroup", dataareaid + "," + dbtype), Restrictions.eq("belongtogroup", dataareaid + ",")), Restrictions.eq("type", "1")});
   }
}
