package com.chenyang.nse.bussiness.tools.dataprocess;

import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BatchUpdateDateUtil {
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;

   public void updateDateForEncryption(String dataSystemId, String tableName, Map<String, String> columnMap, String... primarykeys) throws SQLException, ClassNotFoundException {
      Class.forName("com.mysql.cj.jdbc.Driver");
      Connection conn = DriverManager.getConnection("jdbc:mysql://192.168.2.131:3306/test?characterEncoding=UTF-8", "root", "root");
      conn.setAutoCommit(false);
      List<String> fieldlist = new ArrayList();

      for(String s : columnMap.keySet()) {
         fieldlist.add(s);
      }

      StringBuilder querycolumn = new StringBuilder();
      StringBuilder updateColumn = new StringBuilder();

      for(String s : fieldlist) {
         querycolumn.append(s);
         querycolumn.append(",");
      }

      if (primarykeys.length > 0) {
         for(String primarykey : primarykeys) {
            querycolumn.append(primarykey);
            querycolumn.append(",");
         }
      }

      querycolumn.deleteCharAt(querycolumn.length() - 1);
      String querysql = "select " + querycolumn.toString() + " from  test." + tableName;
      updateColumn.append("update " + tableName + " set ");

      for(String s : fieldlist) {
         updateColumn.append(s);
         updateColumn.append(" = ? ,");
      }

      updateColumn.deleteCharAt(updateColumn.length() - 1);
      if (primarykeys.length > 0) {
         updateColumn.append(" where ");

         for(int i = 0; i < primarykeys.length; ++i) {
            updateColumn.append(primarykeys[i] + " = ?");
            if (i != primarykeys.length - 1) {
               updateColumn.append(" and ");
            }
         }
      }

      updateColumn.append(";");
      PreparedStatement preparedStatement = conn.prepareStatement(querysql);
      ResultSet resultSet = preparedStatement.executeQuery();
      PreparedStatement updateps = conn.prepareStatement(updateColumn.toString());

      while(resultSet.next()) {
         for(int i = 0; i < fieldlist.size(); ++i) {
            String value = resultSet.getString((String)fieldlist.get(i));
            updateps.setString(i + 1, value);
         }

         for(int i = 0; i < primarykeys.length; ++i) {
            updateps.setString(fieldlist.size() + i + 1, resultSet.getString(primarykeys[i]));
         }

         updateps.addBatch();
      }

      updateps.executeBatch();
      conn.commit();
   }

   public static void main(String[] args) {
      BatchUpdateDateUtil b = new BatchUpdateDateUtil();
      HashMap<String, String> stringStringHashMap = new HashMap();
      stringStringHashMap.put("c_name", "");

      try {
         b.updateDateForEncryption("402882057aec38c6017aec614abe0007", "at_privacy", stringStringHashMap, "id");
      } catch (ClassNotFoundException | SQLException e) {
         ((Exception)e).printStackTrace();
      }

   }
}
