package com.chenyang.druid.proxy.jdbc;

import java.util.Calendar;

public final class JdbcParameterInt implements JdbcParameter {
   private static JdbcParameterInt[] cache;
   private final int value;

   private JdbcParameterInt(int value) {
      this.value = value;
   }

   public static JdbcParameterInt valueOf(int value) {
      return value >= 0 && value < cache.length ? cache[value] : new JdbcParameterInt(value);
   }

   public Object getValue() {
      return this.value;
   }

   public long getLength() {
      return 0L;
   }

   public Calendar getCalendar() {
      return null;
   }

   public int getSqlType() {
      return 4;
   }

   static {
      int cacheSize = 127;
      cache = new JdbcParameterInt[cacheSize];

      for(int i = 0; i < cache.length; ++i) {
         cache[i] = new JdbcParameterInt(i);
      }

   }
}
