package com.chenyang.druid.proxy.jdbc;

import java.util.Calendar;

public final class JdbcParameterLong implements JdbcParameter {
   private static JdbcParameterLong[] cache;
   private final long value;

   private JdbcParameterLong(long value) {
      this.value = value;
   }

   public static JdbcParameterLong valueOf(long value) {
      return value >= 0L && value < (long)cache.length ? cache[(int)value] : new JdbcParameterLong(value);
   }

   public Object getValue() {
      return this.value;
   }

   public long getLength() {
      return 0L;
   }

   public Calendar getCalendar() {
      return null;
   }

   public int getSqlType() {
      return -5;
   }

   static {
      int cacheSize = 127;
      cache = new JdbcParameterLong[cacheSize];

      for(int i = 0; i < cache.length; ++i) {
         cache[i] = new JdbcParameterLong((long)i);
      }

   }
}
