package com.chenyang.druid.sql.ast;

import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLPartitionByValue extends SQLPartitionBy {
   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
         this.acceptChild(visitor, this.storeIn);
         this.acceptChild(visitor, this.partitions);
         this.acceptChild(visitor, this.subPartitionBy);
      }

      visitor.endVisit(this);
   }

   public SQLPartitionByValue clone() {
      SQLPartitionByValue x = new SQLPartitionByValue();
      this.cloneTo(x);

      for(SQLExpr column : this.columns) {
         SQLExpr c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

      return x;
   }

   public void cloneTo(SQLPartitionByValue x) {
      super.cloneTo(x);
   }
}
