package com.chenyang.druid.sql.ast;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.visitor.ParameterizedOutputVisitorUtils;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import com.chenyang.druid.sql.visitor.VisitorFeature;
import java.util.List;

public abstract class SQLStatementImpl extends SQLObjectImpl implements SQLStatement {
   protected DbType dbType;
   protected boolean afterSemi;
   protected List<SQLCommentHint> headHints;

   public SQLStatementImpl() {
   }

   public SQLStatementImpl(DbType dbType) {
      this.dbType = dbType;
   }

   public DbType getDbType() {
      return this.dbType;
   }

   public void setDbType(DbType dbType) {
      this.dbType = dbType;
   }

   public String toString() {
      return SQLUtils.toSQLString(this, (DbType)this.dbType);
   }

   public String toString(VisitorFeature... features) {
      return SQLUtils.toSQLString(this, this.dbType, (SQLUtils.FormatOption)null, (VisitorFeature[])features);
   }

   public String toLowerCaseString() {
      return SQLUtils.toSQLString(this, this.dbType, SQLUtils.DEFAULT_LCASE_FORMAT_OPTION);
   }

   public String toUnformattedString() {
      return SQLUtils.toSQLString(this, this.dbType, new SQLUtils.FormatOption(true, false));
   }

   public String toParameterizedString() {
      return ParameterizedOutputVisitorUtils.parameterize((SQLStatement)this, this.dbType);
   }

   protected void accept0(SQLASTVisitor v) {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public List<SQLObject> getChildren() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public boolean isAfterSemi() {
      return this.afterSemi;
   }

   public void setAfterSemi(boolean afterSemi) {
      this.afterSemi = afterSemi;
   }

   public SQLStatement clone() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public List<SQLCommentHint> getHeadHintsDirect() {
      return this.headHints;
   }

   public void setHeadHints(List<SQLCommentHint> headHints) {
      this.headHints = headHints;
   }
}
