package com.chenyang.druid.sql.ast;

import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSubPartitionByHash extends SQLSubPartitionBy {
   protected SQLExpr expr;
   private boolean key;
   protected List<SQLName> storeIn = new ArrayList();

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.subPartitionsCount);
      }

      visitor.endVisit(this);
   }

   public boolean isKey() {
      return this.key;
   }

   public void setKey(boolean key) {
      this.key = key;
   }

   public SQLSubPartitionByHash clone() {
      SQLSubPartitionByHash x = new SQLSubPartitionByHash();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      x.key = this.key;
      return x;
   }

   public boolean isPartitionByColumn(long columnNameHashCode64) {
      return this.expr instanceof SQLName && ((SQLName)this.expr).nameHashCode64() == columnNameHashCode64;
   }

   public List<SQLName> getStoreIn() {
      return this.storeIn;
   }

   public void setStoreIn(List<SQLName> storeIn) {
      this.storeIn = storeIn;
   }
}
