package com.chenyang.druid.sql.ast;

import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLSubPartitionByList extends SQLSubPartitionBy {
   protected SQLName column;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.column);
         this.acceptChild(visitor, this.subPartitionsCount);
      }

      visitor.endVisit(this);
   }

   public SQLName getColumn() {
      return this.column;
   }

   public void setColumn(SQLName column) {
      if (column != null) {
         column.setParent(this);
      }

      this.column = column;
   }

   public SQLSubPartitionByList clone() {
      SQLSubPartitionByList x = new SQLSubPartitionByList();
      if (this.column != null) {
         x.setColumn(this.column.clone());
      }

      return x;
   }

   public boolean isPartitionByColumn(long columnNameHashCode64) {
      return this.column != null && this.column.nameHashCode64() == columnNameHashCode64;
   }
}
