package com.chenyang.druid.sql.ast;

import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSubPartitionByRange extends SQLSubPartitionBy {
   private List<SQLExpr> columns = new ArrayList();

   public List<SQLExpr> getColumns() {
      return this.columns;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.columns);
         this.acceptChild(v, this.subPartitionsCount);
      }

      v.endVisit(this);
   }

   public SQLSubPartitionByRange clone() {
      SQLSubPartitionByRange x = new SQLSubPartitionByRange();

      for(SQLExpr column : this.columns) {
         SQLExpr c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

      return x;
   }

   public boolean isPartitionByColumn(long columnNameHashCode64) {
      for(SQLExpr column : this.columns) {
         if (column instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)column).nameHashCode64() == columnNameHashCode64) {
            return true;
         }
      }

      return false;
   }
}
