package com.chenyang.druid.sql.ast;

import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLUnionDataType extends SQLDataTypeImpl {
   private final List<SQLDataType> items = new ArrayList();

   public String getName() {
      return "UNIONTYPE";
   }

   public List<SQLDataType> getItems() {
      return this.items;
   }

   public void add(SQLDataType item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.items);
      }

      visitor.endVisit(this);
   }

   public SQLUnionDataType clone() {
      SQLUnionDataType x = new SQLUnionDataType();

      for(SQLDataType item : this.items) {
         x.add(item.clone());
      }

      return x;
   }
}
