package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.FastsqlException;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.statement.SQLTableSource;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class SQLAllColumnExpr extends SQLExprImpl {
   private transient SQLTableSource resolvedTableSource;

   public void output(Appendable buf) {
      try {
         buf.append('*');
      } catch (IOException e) {
         throw new FastsqlException("output error", e);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public int hashCode() {
      return 0;
   }

   public boolean equals(Object o) {
      return o instanceof SQLAllColumnExpr;
   }

   public SQLAllColumnExpr clone() {
      SQLAllColumnExpr x = new SQLAllColumnExpr();
      x.resolvedTableSource = this.resolvedTableSource;
      return x;
   }

   public SQLTableSource getResolvedTableSource() {
      return this.resolvedTableSource;
   }

   public void setResolvedTableSource(SQLTableSource resolvedTableSource) {
      this.resolvedTableSource = resolvedTableSource;
   }

   public List getChildren() {
      return Collections.emptyList();
   }
}
