package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLCaseStatement extends SQLStatementImpl implements Serializable {
   private final List<Item> items = new ArrayList();
   private SQLExpr valueExpr;
   private List<SQLStatement> elseStatements = new ArrayList();

   public SQLExpr getValueExpr() {
      return this.valueExpr;
   }

   public void setValueExpr(SQLExpr valueExpr) {
      if (valueExpr != null) {
         valueExpr.setParent(this);
      }

      this.valueExpr = valueExpr;
   }

   public List<SQLStatement> getElseStatements() {
      return this.elseStatements;
   }

   public List<Item> getItems() {
      return this.items;
   }

   public void addItem(Item item) {
      if (item != null) {
         item.setParent(this);
         this.items.add(item);
      }

   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.valueExpr != null) {
            this.valueExpr.accept(visitor);
         }

         if (this.items != null) {
            for(Item item : this.items) {
               if (item != null) {
                  item.accept(visitor);
               }
            }
         }

         if (this.elseStatements != null) {
            for(SQLStatement item : this.elseStatements) {
               if (item != null) {
                  item.accept(visitor);
               }
            }
         }
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.valueExpr != null) {
         children.add(this.valueExpr);
      }

      children.addAll(this.items);
      children.addAll(this.elseStatements);
      return children;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLCaseStatement that = (SQLCaseStatement)o;
         if (!this.items.equals(that.items)) {
            return false;
         } else {
            if (this.valueExpr != null) {
               if (!this.valueExpr.equals(that.valueExpr)) {
                  return false;
               }
            } else if (that.valueExpr != null) {
               return false;
            }

            return this.elseStatements != null ? this.elseStatements.equals(that.elseStatements) : that.elseStatements == null;
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.items.hashCode();
      result = 31 * result + (this.valueExpr != null ? this.valueExpr.hashCode() : 0);
      result = 31 * result + (this.elseStatements != null ? this.elseStatements.hashCode() : 0);
      return result;
   }

   public static class Item extends SQLObjectImpl implements Serializable {
      private static final long serialVersionUID = 1L;
      private SQLExpr conditionExpr;
      private SQLStatement statement;

      public Item() {
      }

      public Item(SQLExpr conditionExpr, SQLStatement statement) {
         this.setConditionExpr(conditionExpr);
         this.setStatement(statement);
      }

      public SQLExpr getConditionExpr() {
         return this.conditionExpr;
      }

      public void setConditionExpr(SQLExpr conditionExpr) {
         if (conditionExpr != null) {
            conditionExpr.setParent(this);
         }

         this.conditionExpr = conditionExpr;
      }

      public SQLStatement getStatement() {
         return this.statement;
      }

      public void setStatement(SQLStatement statement) {
         if (statement != null) {
            statement.setParent(this);
         }

         this.statement = statement;
      }

      protected void accept0(SQLASTVisitor visitor) {
         if (visitor.visit(this)) {
            if (this.conditionExpr != null) {
               this.conditionExpr.accept(visitor);
            }

            if (this.statement != null) {
               this.statement.accept(visitor);
            }
         }

         visitor.endVisit(this);
      }

      public int hashCode() {
         int prime = 31;
         int result = 1;
         result = 31 * result + (this.conditionExpr == null ? 0 : this.conditionExpr.hashCode());
         result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
         return result;
      }

      public boolean equals(Object obj) {
         if (this == obj) {
            return true;
         } else if (obj == null) {
            return false;
         } else if (this.getClass() != obj.getClass()) {
            return false;
         } else {
            Item other = (Item)obj;
            if (this.conditionExpr == null) {
               if (other.conditionExpr != null) {
                  return false;
               }
            } else if (!this.conditionExpr.equals(other.conditionExpr)) {
               return false;
            }

            if (this.statement == null) {
               if (other.statement != null) {
                  return false;
               }
            } else if (!this.statement.equals(other.statement)) {
               return false;
            }

            return true;
         }
      }
   }
}
