package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObjectWithDataType;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Arrays;
import java.util.List;

public class SQLCastExpr extends SQLExprImpl implements SQLObjectWithDataType, SQLReplaceable {
   protected boolean isTry;
   protected SQLExpr expr;
   protected SQLDataType dataType;

   public SQLCastExpr() {
   }

   public SQLCastExpr(SQLExpr expr, SQLDataType dataType) {
      this.setExpr(expr);
      this.setDataType(dataType);
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public SQLDataType getDataType() {
      return this.dataType;
   }

   public long dateTypeHashCode() {
      return this.dataType == null ? 0L : this.dataType.nameHashCode64();
   }

   public void setDataType(SQLDataType dataType) {
      if (dataType != null) {
         dataType.setParent(this);
      }

      this.dataType = dataType;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.dataType != null) {
            this.dataType.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public List getChildren() {
      return Arrays.asList(this.expr, this.dataType);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLCastExpr castExpr = (SQLCastExpr)o;
         if (this.isTry != castExpr.isTry) {
            return false;
         } else {
            if (this.expr != null) {
               if (!this.expr.equals(castExpr.expr)) {
                  return false;
               }
            } else if (castExpr.expr != null) {
               return false;
            }

            return this.dataType != null ? this.dataType.equals(castExpr.dataType) : castExpr.dataType == null;
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.isTry ? 1 : 0;
      result = 31 * result + (this.expr != null ? this.expr.hashCode() : 0);
      result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
      return result;
   }

   public SQLDataType computeDataType() {
      return this.dataType;
   }

   public SQLCastExpr clone() {
      SQLCastExpr x = new SQLCastExpr();
      x.isTry = this.isTry;
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      if (this.dataType != null) {
         x.setDataType(this.dataType.clone());
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         return false;
      }
   }

   public boolean isTry() {
      return this.isTry;
   }

   public void setTry(boolean aTry) {
      this.isTry = aTry;
   }

   public String toString() {
      return SQLUtils.toSQLString(this);
   }
}
