package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class SQLContainsExpr extends SQLExprImpl implements SQLReplaceable, Serializable {
   private static final long serialVersionUID = 1L;
   private boolean not = false;
   private SQLExpr expr;
   private List<SQLExpr> targetList = new ArrayList();

   public SQLContainsExpr() {
   }

   public SQLContainsExpr(SQLExpr expr) {
      this.setExpr(expr);
   }

   public SQLContainsExpr(SQLExpr expr, boolean not) {
      this.setExpr(expr);
      this.not = not;
   }

   public SQLContainsExpr clone() {
      SQLContainsExpr x = new SQLContainsExpr();
      x.not = this.not;
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      for(SQLExpr e : this.targetList) {
         SQLExpr e2 = e.clone();
         e2.setParent(x);
         x.targetList.add(e2);
      }

      return x;
   }

   public boolean isNot() {
      return this.not;
   }

   public void setNot(boolean not) {
      this.not = not;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public List<SQLExpr> getTargetList() {
      return this.targetList;
   }

   public void setTargetList(List<SQLExpr> targetList) {
      this.targetList = targetList;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.targetList != null) {
            for(SQLExpr item : this.targetList) {
               if (item != null) {
                  item.accept(visitor);
               }
            }
         }
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.expr != null) {
         children.add(this.expr);
      }

      children.addAll(this.targetList);
      return children;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
      result = 31 * result + (this.not ? 1231 : 1237);
      result = 31 * result + (this.targetList == null ? 0 : this.targetList.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLContainsExpr other = (SQLContainsExpr)obj;
         if (this.expr == null) {
            if (other.expr != null) {
               return false;
            }
         } else if (!this.expr.equals(other.expr)) {
            return false;
         }

         if (this.not != other.not) {
            return false;
         } else {
            if (this.targetList == null) {
               if (other.targetList != null) {
                  return false;
               }
            } else if (!this.targetList.equals(other.targetList)) {
               return false;
            }

            return true;
         }
      }
   }

   public SQLDataType computeDataType() {
      return SQLBooleanExpr.DATA_TYPE;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         for(int i = 0; i < this.targetList.size(); ++i) {
            if (this.targetList.get(i) == expr) {
               this.targetList.set(i, target);
               target.setParent(this);
               return true;
            }
         }

         return false;
      }
   }
}
