package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.FastsqlException;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SQLCurrentOfCursorExpr extends SQLExprImpl implements SQLReplaceable {
   private SQLName cursorName;

   public SQLCurrentOfCursorExpr() {
   }

   public SQLCurrentOfCursorExpr(SQLName cursorName) {
      this.cursorName = cursorName;
   }

   public SQLCurrentOfCursorExpr clone() {
      SQLCurrentOfCursorExpr x = new SQLCurrentOfCursorExpr();
      if (this.cursorName != null) {
         x.setCursorName(this.cursorName.clone());
      }

      return x;
   }

   public SQLName getCursorName() {
      return this.cursorName;
   }

   public void setCursorName(SQLName cursorName) {
      if (cursorName != null) {
         cursorName.setParent(this);
      }

      this.cursorName = cursorName;
   }

   public void output(Appendable buf) {
      try {
         buf.append("CURRENT OF ");
         this.cursorName.output(buf);
      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.cursorName != null) {
         this.cursorName.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.cursorName);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.cursorName == null ? 0 : this.cursorName.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLCurrentOfCursorExpr other = (SQLCurrentOfCursorExpr)obj;
         if (this.cursorName == null) {
            if (other.cursorName != null) {
               return false;
            }
         } else if (!this.cursorName.equals(other.cursorName)) {
            return false;
         }

         return true;
      }
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.cursorName == expr) {
         this.setCursorName((SQLName)target);
         return true;
      } else {
         return false;
      }
   }
}
