package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.statement.SQLColumnDefinition;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import com.chenyang.druid.util.FnvHash;
import java.util.Collections;
import java.util.List;

public class SQLDbLinkExpr extends SQLExprImpl implements SQLName, SQLExpr, SQLReplaceable {
   private SQLExpr expr;
   private String dbLink;
   private long dbLinkHashCode64;
   private long hashCode64;

   public String getSimpleName() {
      return this.dbLink;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      this.expr = expr;
   }

   public String getDbLink() {
      return this.dbLink;
   }

   public void setDbLink(String dbLink) {
      this.dbLink = dbLink;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
      }

      visitor.endVisit(this);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         return false;
      }
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.expr);
   }

   public int hashCode() {
      long value = this.hashCode64();
      return (int)(value ^ value >>> 32);
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLDbLinkExpr other = (SQLDbLinkExpr)obj;
         return this.hashCode64() == other.hashCode64();
      }
   }

   public SQLDbLinkExpr clone() {
      SQLDbLinkExpr x = new SQLDbLinkExpr();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      x.dbLink = this.dbLink;
      return x;
   }

   public long nameHashCode64() {
      if (this.dbLinkHashCode64 == 0L && this.dbLink != null) {
         this.dbLinkHashCode64 = FnvHash.hashCode64(this.dbLink);
      }

      return this.dbLinkHashCode64;
   }

   public long hashCode64() {
      if (this.hashCode64 == 0L) {
         long hash;
         if (this.expr instanceof SQLName) {
            hash = ((SQLName)this.expr).hashCode64();
            hash ^= 64L;
            hash *= 1099511628211L;
         } else if (this.expr == null) {
            hash = -3750763034362895579L;
         } else {
            hash = FnvHash.fnv1a_64_lower(this.expr.toString());
            hash ^= 64L;
            hash *= 1099511628211L;
         }

         hash = FnvHash.hashCode64(hash, this.dbLink);
         this.hashCode64 = hash;
      }

      return this.hashCode64;
   }

   public SQLColumnDefinition getResolvedColumn() {
      return null;
   }
}
