package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.FastsqlException;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class SQLNullExpr extends SQLExprImpl implements SQLLiteralExpr, SQLValuableExpr {
   public SQLNullExpr() {
   }

   public SQLNullExpr(SQLObject parent) {
      this.parent = parent;
   }

   public void output(Appendable buf) {
      try {
         buf.append("NULL");
      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public int hashCode() {
      return 0;
   }

   public boolean equals(Object o) {
      return o instanceof SQLNullExpr;
   }

   public Object getValue() {
      return SQLEvalVisitor.EVAL_VALUE_NULL;
   }

   public SQLNullExpr clone() {
      return new SQLNullExpr();
   }

   public List getChildren() {
      return Collections.emptyList();
   }
}
