package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class SQLSizeExpr extends SQLExprImpl {
   private SQLExpr value;
   private Unit unit;

   public SQLSizeExpr() {
   }

   public SQLSizeExpr(String value, char unit) {
      this.unit = Unit.valueOf(Character.toString(unit).toUpperCase());
      if (value.indexOf(46) == -1) {
         this.value = new SQLIntegerExpr(Integer.parseInt(value));
      } else {
         this.value = new SQLNumberExpr(new BigDecimal(value));
      }

   }

   public SQLSizeExpr(SQLExpr value, Unit unit) {
      this.value = value;
      this.unit = unit;
   }

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.value != null) {
         this.value.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.value);
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
   }

   public Unit getUnit() {
      return this.unit;
   }

   public void setUnit(Unit unit) {
      this.unit = unit;
   }

   public SQLSizeExpr clone() {
      SQLSizeExpr x = new SQLSizeExpr();
      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      x.unit = this.unit;
      return x;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLSizeExpr that = (SQLSizeExpr)o;
         if (this.value != null) {
            if (!this.value.equals(that.value)) {
               return false;
            }
         } else if (that.value != null) {
            return false;
         }

         return this.unit == that.unit;
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.value != null ? this.value.hashCode() : 0;
      result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
      return result;
   }

   public static enum Unit {
      B,
      K,
      M,
      G,
      T,
      P,
      E;
   }
}
