package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLTinyIntExpr extends SQLNumericLiteralExpr implements SQLValuableExpr {
   private Byte value;

   public SQLTinyIntExpr() {
   }

   public SQLTinyIntExpr(Byte value) {
      this.value = value;
   }

   public SQLTinyIntExpr(String value) {
      if (value.startsWith("--")) {
         value = value.substring(2);
      }

      this.value = Byte.valueOf(value);
   }

   public SQLTinyIntExpr clone() {
      return new SQLTinyIntExpr(this.value);
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public Number getNumber() {
      return this.value;
   }

   public Byte getValue() {
      return this.value;
   }

   public void setValue(Byte value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLTinyIntExpr other = (SQLTinyIntExpr)obj;
         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }

   public void setNumber(Number number) {
      if (number == null) {
         this.setValue((Byte)null);
      } else {
         this.setValue((Byte)number);
      }
   }
}
