package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.sql.ast.SQLDataType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class SQLUnaryExpr extends SQLExprImpl implements Serializable, SQLReplaceable {
   private static final long serialVersionUID = 1L;
   private SQLExpr expr;
   private SQLUnaryOperator operator;

   public SQLUnaryExpr() {
   }

   public SQLUnaryExpr(SQLUnaryOperator operator, SQLExpr expr) {
      this.operator = operator;
      this.setExpr(expr);
   }

   public SQLUnaryExpr clone() {
      SQLUnaryExpr x = new SQLUnaryExpr();
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      x.operator = this.operator;
      return x;
   }

   public SQLUnaryOperator getOperator() {
      return this.operator;
   }

   public void setOperator(SQLUnaryOperator operator) {
      this.operator = operator;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.expr != null) {
         this.expr.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.expr);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
      result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLUnaryExpr other = (SQLUnaryExpr)obj;
         if (this.expr == null) {
            if (other.expr != null) {
               return false;
            }
         } else if (!this.expr.equals(other.expr)) {
            return false;
         }

         return this.operator == other.operator;
      }
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         return false;
      }
   }

   public SQLDataType computeDataType() {
      switch (this.operator) {
         case Plus:
         case Negative:
         case Compl:
         case Not:
            return this.expr.computeDataType();
         default:
            return null;
      }
   }
}
