package com.chenyang.druid.sql.ast.expr;

import com.chenyang.druid.FastsqlException;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLVariantRefExpr extends SQLExprImpl {
   private String name;
   private boolean global;
   private boolean session;
   private int index;

   public SQLVariantRefExpr(String name) {
      this.global = false;
      this.session = false;
      this.index = -1;
      this.name = name;
   }

   public SQLVariantRefExpr(String name, SQLObject parent) {
      this.global = false;
      this.session = false;
      this.index = -1;
      this.name = name;
      this.parent = parent;
   }

   public SQLVariantRefExpr(String name, boolean global) {
      this(name, global, false);
   }

   public SQLVariantRefExpr(String name, boolean global, boolean session) {
      this.global = false;
      this.session = false;
      this.index = -1;
      this.name = name;
      this.global = global;
      this.session = session;
   }

   public SQLVariantRefExpr() {
      this.global = false;
      this.session = false;
      this.index = -1;
   }

   public int getIndex() {
      return this.index;
   }

   public void setIndex(int index) {
      this.index = index;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public void output(Appendable buf) {
      try {
         buf.append(this.name);
      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (!(obj instanceof SQLVariantRefExpr)) {
         return false;
      } else {
         SQLVariantRefExpr other = (SQLVariantRefExpr)obj;
         if (this.name == null) {
            if (other.name != null) {
               return false;
            }
         } else if (!this.name.equals(other.name)) {
            return false;
         }

         return true;
      }
   }

   public boolean isGlobal() {
      return this.global;
   }

   public void setGlobal(boolean global) {
      this.global = global;
   }

   public boolean isSession() {
      return this.session;
   }

   public void setSession(boolean session) {
      this.session = session;
   }

   public SQLVariantRefExpr clone() {
      SQLVariantRefExpr var = new SQLVariantRefExpr(this.name, this.global, this.session);
      if (this.attributes != null) {
         var.attributes = new HashMap(this.attributes.size());

         for(Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof SQLObject) {
               var.attributes.put(k, ((SQLObject)v).clone());
            } else {
               var.attributes.put(k, v);
            }
         }
      }

      var.index = this.index;
      return var;
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }
}
