package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLAlterProcedureStatement extends SQLStatementImpl implements SQLAlterStatement {
   private SQLExpr name;
   private boolean compile = false;
   private boolean reuseSettings = false;
   private SQLExpr comment;
   private boolean languageSql;
   private boolean containsSql;
   private boolean modifiesSqlData;
   private boolean noSql;
   private boolean readSqlData;
   private SQLExpr sqlSecurity;

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr name) {
      this.name = name;
   }

   public boolean isCompile() {
      return this.compile;
   }

   public void setCompile(boolean compile) {
      this.compile = compile;
   }

   public boolean isReuseSettings() {
      return this.reuseSettings;
   }

   public void setReuseSettings(boolean reuseSettings) {
      this.reuseSettings = reuseSettings;
   }

   public boolean isLanguageSql() {
      return this.languageSql;
   }

   public void setLanguageSql(boolean languageSql) {
      this.languageSql = languageSql;
   }

   public boolean isContainsSql() {
      return this.containsSql;
   }

   public void setContainsSql(boolean containsSql) {
      this.containsSql = containsSql;
   }

   public SQLExpr getSqlSecurity() {
      return this.sqlSecurity;
   }

   public void setSqlSecurity(SQLExpr sqlSecurity) {
      if (sqlSecurity != null) {
         sqlSecurity.setParent(this);
      }

      this.sqlSecurity = sqlSecurity;
   }

   public SQLExpr getComment() {
      return this.comment;
   }

   public void setComment(SQLExpr comment) {
      if (comment != null) {
         comment.setParent(this);
      }

      this.comment = comment;
   }

   public boolean isModifiesSqlData() {
      return this.modifiesSqlData;
   }

   public void setModifiesSqlData(boolean modifiesSqlData) {
      this.modifiesSqlData = modifiesSqlData;
   }

   public boolean isNoSql() {
      return this.noSql;
   }

   public void setNoSql(boolean noSql) {
      this.noSql = noSql;
   }

   public boolean isReadSqlData() {
      return this.readSqlData;
   }

   public void setReadSqlData(boolean readSqlData) {
      this.readSqlData = readSqlData;
   }
}
