package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLAlterTableAddConstraint extends SQLObjectImpl implements SQLAlterTableItem {
   private SQLConstraint constraint;
   private boolean withNoCheck = false;

   public SQLAlterTableAddConstraint() {
   }

   public SQLAlterTableAddConstraint(SQLConstraint constraint) {
      this.setConstraint(constraint);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.constraint);
      }

      visitor.endVisit(this);
   }

   public SQLConstraint getConstraint() {
      return this.constraint;
   }

   public void setConstraint(SQLConstraint constraint) {
      if (constraint != null) {
         constraint.setParent(this);
      }

      this.constraint = constraint;
   }

   public boolean isWithNoCheck() {
      return this.withNoCheck;
   }

   public void setWithNoCheck(boolean withNoCheck) {
      this.withNoCheck = withNoCheck;
   }
}
