package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableSetOption extends SQLObjectImpl implements SQLAlterTableItem {
   private List<SQLAssignItem> options = new ArrayList();
   private SQLName on;

   public List<SQLAssignItem> getOptions() {
      return this.options;
   }

   public void addOption(SQLAssignItem item) {
      item.setParent(this);
      this.options.add(item);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.options);
         this.acceptChild(visitor, this.on);
      }

      visitor.endVisit(this);
   }

   public SQLName getOn() {
      return this.on;
   }

   public void setOn(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.on = x;
   }
}
