package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLPartitionBy;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableStatement extends SQLStatementImpl implements SQLDDLStatement, SQLAlterStatement {
   private SQLExprTableSource tableSource;
   private List<SQLAlterTableItem> items = new ArrayList();
   private boolean ignore = false;
   private boolean online = false;
   private boolean offline = false;
   private boolean updateGlobalIndexes = false;
   private boolean invalidateGlobalIndexes = false;
   private boolean removePatiting = false;
   private boolean upgradePatiting = false;
   private List<SQLAssignItem> tableOptions = new ArrayList();
   private SQLPartitionBy partition = null;
   private boolean mergeSmallFiles = false;
   protected final List<SQLSelectOrderByItem> clusteredBy = new ArrayList();
   protected final List<SQLSelectOrderByItem> sortedBy = new ArrayList();
   protected int buckets;
   protected int shards;
   private boolean ifExists = false;

   public SQLAlterTableStatement() {
   }

   public SQLAlterTableStatement(DbType dbType) {
      super(dbType);
   }

   public boolean isIgnore() {
      return this.ignore;
   }

   public void setIgnore(boolean ignore) {
      this.ignore = ignore;
   }

   public boolean isOnline() {
      return this.online;
   }

   public void setOnline(boolean online) {
      this.online = online;
   }

   public boolean isOffline() {
      return this.offline;
   }

   public void setOffline(boolean offline) {
      this.offline = offline;
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public boolean isRemovePatiting() {
      return this.removePatiting;
   }

   public void setRemovePatiting(boolean removePatiting) {
      this.removePatiting = removePatiting;
   }

   public boolean isUpgradePatiting() {
      return this.upgradePatiting;
   }

   public void setUpgradePatiting(boolean upgradePatiting) {
      this.upgradePatiting = upgradePatiting;
   }

   public boolean isUpdateGlobalIndexes() {
      return this.updateGlobalIndexes;
   }

   public void setUpdateGlobalIndexes(boolean updateGlobalIndexes) {
      this.updateGlobalIndexes = updateGlobalIndexes;
   }

   public boolean isInvalidateGlobalIndexes() {
      return this.invalidateGlobalIndexes;
   }

   public void setInvalidateGlobalIndexes(boolean invalidateGlobalIndexes) {
      this.invalidateGlobalIndexes = invalidateGlobalIndexes;
   }

   public boolean isMergeSmallFiles() {
      return this.mergeSmallFiles;
   }

   public void setMergeSmallFiles(boolean mergeSmallFiles) {
      this.mergeSmallFiles = mergeSmallFiles;
   }

   public List<SQLAlterTableItem> getItems() {
      return this.items;
   }

   public void addItem(SQLAlterTableItem item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   public SQLExprTableSource getTableSource() {
      return this.tableSource;
   }

   public void setTableSource(SQLExprTableSource tableSource) {
      this.tableSource = tableSource;
   }

   public void setTableSource(SQLExpr table) {
      this.setTableSource(new SQLExprTableSource(table));
   }

   public SQLName getName() {
      return this.getTableSource() == null ? null : (SQLName)this.getTableSource().getExpr();
   }

   public long nameHashCode64() {
      return this.getTableSource() == null ? 0L : ((SQLName)this.getTableSource().getExpr()).nameHashCode64();
   }

   public void setName(SQLName name) {
      this.setTableSource(new SQLExprTableSource(name));
   }

   public List<SQLAssignItem> getTableOptions() {
      return this.tableOptions;
   }

   public SQLPartitionBy getPartition() {
      return this.partition;
   }

   public void setPartition(SQLPartitionBy partition) {
      this.partition = partition;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getTableSource());
         this.acceptChild(visitor, this.getItems());
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.tableSource != null) {
         children.add(this.tableSource);
      }

      children.addAll(this.items);
      return children;
   }

   public String getTableName() {
      if (this.tableSource == null) {
         return null;
      } else {
         SQLExpr expr = this.tableSource.getExpr();
         if (expr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)expr).getName();
         } else {
            return expr instanceof SQLPropertyExpr ? ((SQLPropertyExpr)expr).getName() : null;
         }
      }
   }

   public String getSchema() {
      SQLName name = this.getName();
      if (name == null) {
         return null;
      } else {
         return name instanceof SQLPropertyExpr ? ((SQLPropertyExpr)name).getOwnernName() : null;
      }
   }

   public List<SQLSelectOrderByItem> getClusteredBy() {
      return this.clusteredBy;
   }

   public void addClusteredByItem(SQLSelectOrderByItem item) {
      item.setParent(this);
      this.clusteredBy.add(item);
   }

   public List<SQLSelectOrderByItem> getSortedBy() {
      return this.sortedBy;
   }

   public void addSortedByItem(SQLSelectOrderByItem item) {
      item.setParent(this);
      this.sortedBy.add(item);
   }

   public int getBuckets() {
      return this.buckets;
   }

   public void setBuckets(int buckets) {
      this.buckets = buckets;
   }

   public int getShards() {
      return this.shards;
   }

   public void setShards(int shards) {
      this.shards = shards;
   }
}
