package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLCreateDatabaseStatement extends SQLStatementImpl implements SQLCreateStatement {
   protected SQLName name;
   protected String characterSet;
   protected String collate;
   protected List<SQLCommentHint> hints;
   protected boolean ifNotExists = false;
   protected SQLExpr comment;
   protected SQLExpr location;
   protected final List<SQLAssignItem> dbProperties = new ArrayList();
   protected Map<String, SQLExpr> options = new HashMap();
   protected String user;
   protected SQLExpr password;
   protected final List<SQLAssignItem> storedOn = new ArrayList();
   protected final List<List<SQLAssignItem>> storedBy = new ArrayList();
   protected SQLExpr storedAs;
   protected SQLExpr storedIn;
   protected boolean physical;

   public SQLCreateDatabaseStatement() {
   }

   public SQLCreateDatabaseStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      return children;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public String getCharacterSet() {
      return this.characterSet;
   }

   public void setCharacterSet(String characterSet) {
      this.characterSet = characterSet;
   }

   public String getCollate() {
      return this.collate;
   }

   public void setCollate(String collate) {
      this.collate = collate;
   }

   public List<SQLCommentHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLCommentHint> hints) {
      this.hints = hints;
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }

   public SQLExpr getComment() {
      return this.comment;
   }

   public String getUser() {
      return this.user;
   }

   public void setUser(String user) {
      this.user = user;
   }

   public void setComment(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.comment = x;
   }

   public SQLExpr getLocation() {
      return this.location;
   }

   public Map<String, SQLExpr> getOptions() {
      return this.options;
   }

   public void setLocation(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.location = x;
   }

   public List<SQLAssignItem> getDbProperties() {
      return this.dbProperties;
   }

   public void setOptions(Map<String, SQLExpr> options) {
      this.options = options;
   }

   public List<SQLAssignItem> getStoredOn() {
      return this.storedOn;
   }

   public List<List<SQLAssignItem>> getStoredBy() {
      return this.storedBy;
   }

   public SQLExpr getStoredAs() {
      return this.storedAs;
   }

   public void setStoredAs(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.storedAs = x;
   }

   public SQLExpr getStoredIn() {
      return this.storedIn;
   }

   public void setStoredIn(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.storedIn = x;
   }

   public SQLExpr getPassword() {
      return this.password;
   }

   public void setPassword(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.password = x;
   }

   public String getDatabaseName() {
      if (this.name == null) {
         return null;
      } else {
         return this.name instanceof SQLName ? this.name.getSimpleName() : null;
      }
   }

   public void setDatabase(String database) {
      SQLExpr expr = SQLUtils.toSQLExpr(database);
      if (expr instanceof SQLIdentifierExpr && this.name instanceof SQLPropertyExpr) {
         ((SQLPropertyExpr)this.name).setName(database);
      } else {
         expr.setParent(this);
         this.name = (SQLName)expr;
      }
   }

   public String getServer() {
      if (this.name instanceof SQLPropertyExpr) {
         SQLExpr owner = ((SQLPropertyExpr)this.name).getOwner();
         if (owner instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)owner).getName();
         }

         if (owner instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)owner).getName();
         }
      }

      return null;
   }

   public boolean setServer(String server) {
      if (this.name == null) {
         return false;
      } else if (this.name instanceof SQLIdentifierExpr) {
         SQLPropertyExpr propertyExpr = new SQLPropertyExpr(new SQLIdentifierExpr(server), ((SQLIdentifierExpr)this.name).getName());
         propertyExpr.setParent(this);
         this.name = propertyExpr;
         return true;
      } else {
         if (this.name instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)this.name;
            SQLExpr owner = propertyExpr.getOwner();
            if (owner instanceof SQLIdentifierExpr) {
               propertyExpr.setOwner((SQLExpr)(new SQLIdentifierExpr(server)));
               return true;
            }

            if (owner instanceof SQLPropertyExpr) {
               ((SQLPropertyExpr)owner).setName(server);
               return true;
            }
         }

         return false;
      }
   }

   public boolean isPhysical() {
      return this.physical;
   }

   public void setPhysical(boolean physical) {
      this.physical = physical;
   }
}
