package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCreateTriggerStatement extends SQLStatementImpl implements SQLCreateStatement {
   private SQLName name;
   private boolean orReplace = false;
   private TriggerType triggerType;
   private SQLName definer;
   private boolean update;
   private boolean delete;
   private boolean insert;
   private SQLExprTableSource on;
   private boolean forEachRow = false;
   private List<SQLName> updateOfColumns = new ArrayList();
   private SQLExpr when;
   private SQLStatement body;
   private SQLExpr triggerOrder;
   private SQLExpr otherTriggerName;

   public SQLCreateTriggerStatement() {
   }

   public SQLCreateTriggerStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.updateOfColumns);
         this.acceptChild(visitor, this.on);
         this.acceptChild(visitor, this.when);
         this.acceptChild(visitor, this.body);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      children.addAll(this.updateOfColumns);
      if (this.on != null) {
         children.add(this.on);
      }

      if (this.when != null) {
         children.add(this.when);
      }

      if (this.body != null) {
         children.add(this.body);
      }

      return children;
   }

   public SQLExprTableSource getOn() {
      return this.on;
   }

   public void setOn(SQLName on) {
      this.setOn(new SQLExprTableSource(on));
   }

   public void setOn(SQLExprTableSource on) {
      if (on != null) {
         on.setParent(this);
      }

      this.on = on;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public SQLStatement getBody() {
      return this.body;
   }

   public void setBody(SQLStatement body) {
      if (body != null) {
         body.setParent(this);
      }

      this.body = body;
   }

   public boolean isOrReplace() {
      return this.orReplace;
   }

   public void setOrReplace(boolean orReplace) {
      this.orReplace = orReplace;
   }

   public TriggerType getTriggerType() {
      return this.triggerType;
   }

   public void setTriggerType(TriggerType triggerType) {
      this.triggerType = triggerType;
   }

   public List<TriggerEvent> getTriggerEvents() {
      return null;
   }

   public boolean isForEachRow() {
      return this.forEachRow;
   }

   public void setForEachRow(boolean forEachRow) {
      this.forEachRow = forEachRow;
   }

   public List<SQLName> getUpdateOfColumns() {
      return this.updateOfColumns;
   }

   public SQLExpr getWhen() {
      return this.when;
   }

   public void setWhen(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.when = x;
   }

   public boolean isUpdate() {
      return this.update;
   }

   public void setUpdate(boolean update) {
      this.update = update;
   }

   public boolean isDelete() {
      return this.delete;
   }

   public void setDelete(boolean delete) {
      this.delete = delete;
   }

   public boolean isInsert() {
      return this.insert;
   }

   public void setInsert(boolean insert) {
      this.insert = insert;
   }

   public SQLName getDefiner() {
      return this.definer;
   }

   public SQLExpr getTriggerOrder() {
      return this.triggerOrder;
   }

   public void setTriggerOrder(SQLExpr triggerOrder) {
      this.triggerOrder = triggerOrder;
   }

   public SQLExpr getOtherTriggerName() {
      return this.otherTriggerName;
   }

   public void setOtherTriggerName(SQLExpr otherTriggerName) {
      this.otherTriggerName = otherTriggerName;
   }

   public void setDefiner(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.definer = x;
   }

   public static enum TriggerType {
      BEFORE,
      AFTER,
      INSTEAD_OF;
   }

   public static enum TriggerEvent {
      INSERT,
      UPDATE,
      DELETE;
   }
}
