package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDropLogFileGroupStatement extends SQLStatementImpl implements SQLDropStatement {
   private SQLExpr name;
   private SQLExpr engine;

   public SQLDropLogFileGroupStatement() {
   }

   public SQLDropLogFileGroupStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.engine);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public SQLExpr getEngine() {
      return this.engine;
   }

   public void setEngine(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.engine = x;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      return children;
   }
}
