package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDropSequenceStatement extends SQLStatementImpl implements SQLDropStatement, SQLReplaceable {
   private SQLName name;
   private boolean ifExists;

   public SQLDropSequenceStatement() {
   }

   public SQLDropSequenceStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      return children;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public String getSchema() {
      SQLName name = this.getName();
      if (name == null) {
         return null;
      } else {
         return name instanceof SQLPropertyExpr ? ((SQLPropertyExpr)name).getOwnernName() : null;
      }
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.name == expr) {
         this.setName((SQLName)target);
         return true;
      } else {
         return false;
      }
   }
}
