package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLDropTableSpaceStatement extends SQLStatementImpl implements SQLDropStatement, SQLReplaceable {
   private SQLName name;
   private boolean ifExists;
   private SQLExpr engine;
   private boolean includingContents;

   public boolean isIncludingContents() {
      return this.includingContents;
   }

   public void setIncludingContents(boolean includingContents) {
      this.includingContents = includingContents;
   }

   public SQLDropTableSpaceStatement() {
   }

   public SQLDropTableSpaceStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public String getTableSpaceName() {
      if (this.name == null) {
         return null;
      } else {
         return this.name instanceof SQLName ? this.name.getSimpleName() : null;
      }
   }

   public SQLExpr getEngine() {
      return this.engine;
   }

   public void setEngine(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.engine = x;
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.name == expr) {
         this.setName((SQLName)target);
         return true;
      } else {
         return false;
      }
   }
}
