package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDropViewStatement extends SQLStatementImpl implements SQLDropStatement {
   protected List<SQLExprTableSource> tableSources;
   protected boolean cascade;
   protected boolean restrict;
   protected boolean ifExists;

   public SQLDropViewStatement() {
      this.tableSources = new ArrayList();
      this.cascade = false;
      this.restrict = false;
      this.ifExists = false;
   }

   public SQLDropViewStatement(DbType dbType) {
      super(dbType);
      this.tableSources = new ArrayList();
      this.cascade = false;
      this.restrict = false;
      this.ifExists = false;
   }

   public SQLDropViewStatement(SQLName name) {
      this(new SQLExprTableSource(name));
   }

   public SQLDropViewStatement(SQLExprTableSource tableSource) {
      this.tableSources = new ArrayList();
      this.cascade = false;
      this.restrict = false;
      this.ifExists = false;
      this.tableSources.add(tableSource);
   }

   public List<SQLExprTableSource> getTableSources() {
      return this.tableSources;
   }

   public void addPartition(SQLExprTableSource tableSource) {
      if (tableSource != null) {
         tableSource.setParent(this);
      }

      this.tableSources.add(tableSource);
   }

   public void setName(SQLName name) {
      this.addTableSource(new SQLExprTableSource(name));
   }

   public void addTableSource(SQLName name) {
      this.addTableSource(new SQLExprTableSource(name));
   }

   public void addTableSource(SQLExprTableSource tableSource) {
      this.tableSources.add(tableSource);
   }

   public boolean isCascade() {
      return this.cascade;
   }

   public void setCascade(boolean cascade) {
      this.cascade = cascade;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         for(int i = 0; i < this.tableSources.size(); ++i) {
            SQLExprTableSource item = (SQLExprTableSource)this.tableSources.get(i);
            if (item != null) {
               item.accept(visitor);
            }
         }
      }

      visitor.endVisit(this);
   }

   public boolean isRestrict() {
      return this.restrict;
   }

   public void setRestrict(boolean restrict) {
      this.restrict = restrict;
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public List getChildren() {
      return this.tableSources;
   }
}
