package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLErrorLoggingClause extends SQLObjectImpl {
   private SQLName into;
   private SQLExpr simpleExpression;
   private SQLExpr limit;

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.into);
         this.acceptChild(visitor, this.simpleExpression);
         this.acceptChild(visitor, this.limit);
      }

      visitor.endVisit(this);
   }

   public SQLName getInto() {
      return this.into;
   }

   public void setInto(SQLName into) {
      this.into = into;
   }

   public SQLExpr getSimpleExpression() {
      return this.simpleExpression;
   }

   public void setSimpleExpression(SQLExpr simpleExpression) {
      this.simpleExpression = simpleExpression;
   }

   public SQLExpr getLimit() {
      return this.limit;
   }

   public void setLimit(SQLExpr limit) {
      this.limit = limit;
   }

   public SQLErrorLoggingClause clone() {
      SQLErrorLoggingClause x = new SQLErrorLoggingClause();
      if (this.into != null) {
         x.setInto(this.into.clone());
      }

      if (this.simpleExpression != null) {
         x.setSimpleExpression(this.simpleExpression.clone());
      }

      if (this.limit != null) {
         x.setLimit(this.limit.clone());
      }

      return x;
   }
}
