package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLExplainAnalyzeStatement extends SQLStatementImpl {
   protected SQLSelect select;

   public SQLExplainAnalyzeStatement() {
   }

   public SQLExplainAnalyzeStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.select);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.select != null) {
         children.add(this.select);
      }

      return children;
   }

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect select) {
      this.select = select;
   }
}
