package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLHint;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLMergeStatement extends SQLStatementImpl {
   private final List<SQLHint> hints = new ArrayList();
   private SQLTableSource into;
   private String alias;
   private SQLTableSource using;
   private SQLExpr on;
   private MergeUpdateClause updateClause;
   private MergeInsertClause insertClause;
   private SQLErrorLoggingClause errorLoggingClause;

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.into);
         this.acceptChild(visitor, this.using);
         this.acceptChild(visitor, this.on);
         this.acceptChild(visitor, this.updateClause);
         this.acceptChild(visitor, this.insertClause);
         this.acceptChild(visitor, this.errorLoggingClause);
      }

      visitor.endVisit(this);
   }

   public String getAlias() {
      return this.into.getAlias();
   }

   public SQLTableSource getInto() {
      return this.into;
   }

   public void setInto(SQLName into) {
      this.setInto((SQLTableSource)(new SQLExprTableSource(into)));
   }

   public void setInto(SQLTableSource into) {
      if (into != null) {
         into.setParent(this);
      }

      this.into = into;
   }

   public SQLTableSource getUsing() {
      return this.using;
   }

   public void setUsing(SQLTableSource using) {
      this.using = using;
   }

   public SQLExpr getOn() {
      return this.on;
   }

   public void setOn(SQLExpr on) {
      this.on = on;
   }

   public MergeUpdateClause getUpdateClause() {
      return this.updateClause;
   }

   public void setUpdateClause(MergeUpdateClause updateClause) {
      this.updateClause = updateClause;
   }

   public MergeInsertClause getInsertClause() {
      return this.insertClause;
   }

   public void setInsertClause(MergeInsertClause insertClause) {
      this.insertClause = insertClause;
   }

   public SQLErrorLoggingClause getErrorLoggingClause() {
      return this.errorLoggingClause;
   }

   public void setErrorLoggingClause(SQLErrorLoggingClause errorLoggingClause) {
      this.errorLoggingClause = errorLoggingClause;
   }

   public List<SQLHint> getHints() {
      return this.hints;
   }

   public static class MergeUpdateClause extends SQLObjectImpl {
      private List<SQLUpdateSetItem> items = new ArrayList();
      private SQLExpr where;
      private SQLExpr deleteWhere;

      public List<SQLUpdateSetItem> getItems() {
         return this.items;
      }

      public void addItem(SQLUpdateSetItem item) {
         if (item != null) {
            item.setParent(this);
         }

         this.items.add(item);
      }

      public SQLExpr getWhere() {
         return this.where;
      }

      public void setWhere(SQLExpr where) {
         this.where = where;
      }

      public SQLExpr getDeleteWhere() {
         return this.deleteWhere;
      }

      public void setDeleteWhere(SQLExpr x) {
         if (x != null) {
            x.setParent(this);
         }

         this.deleteWhere = x;
      }

      public void accept0(SQLASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.items);
            this.acceptChild(visitor, this.where);
            this.acceptChild(visitor, this.deleteWhere);
         }

         visitor.endVisit(this);
      }
   }

   public static class MergeInsertClause extends SQLObjectImpl {
      private List<SQLExpr> columns = new ArrayList();
      private List<SQLExpr> values = new ArrayList();
      private SQLExpr where;

      public void accept0(SQLASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.values);
            this.acceptChild(visitor, this.where);
         }

         visitor.endVisit(this);
      }

      public List<SQLExpr> getColumns() {
         return this.columns;
      }

      public void setColumns(List<SQLExpr> columns) {
         this.columns = columns;
      }

      public List<SQLExpr> getValues() {
         return this.values;
      }

      public void setValues(List<SQLExpr> values) {
         this.values = values;
      }

      public SQLExpr getWhere() {
         return this.where;
      }

      public void setWhere(SQLExpr x) {
         if (x != null) {
            x.setParent(this);
         }

         this.where = x;
      }
   }
}
